/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit4;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.junit4.ContextImpl;

class WeldJunit4Extension
implements Extension {
    private final Set<Class<? extends Annotation>> scopesToActivate;
    private final List<ContextImpl> contexts;

    public WeldJunit4Extension(Set<Class<? extends Annotation>> scopesToActivate) {
        this.scopesToActivate = scopesToActivate;
        this.contexts = new ArrayList<ContextImpl>();
    }

    void afterBeandiscovery(@Observes AfterBeanDiscovery event) {
        for (Class<? extends Annotation> scope : this.scopesToActivate) {
            ContextImpl ctx = new ContextImpl(scope);
            this.contexts.add(ctx);
            event.addContext((Context)ctx);
        }
    }

    void activateContexts() {
        if (this.contexts.isEmpty()) {
            return;
        }
        for (ContextImpl context : this.contexts) {
            context.activate();
        }
    }

    void deactivateContexts() {
        if (this.contexts.isEmpty()) {
            return;
        }
        for (ContextImpl context : this.contexts) {
            context.deactivate();
        }
    }
}

