/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.weld.logging.Json;

public class LogMessageIndexDiff {
    public static void main(String[] args) {
        if (args.length == 0) {
            LogMessageIndexDiff.printUsage();
            return;
        }
        File outputFile = null;
        ArrayList<File> indexFiles = new ArrayList<File>();
        boolean detectCollisionsOnly = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-o".equals(arg)) {
                if (i >= args.length) {
                    throw new IllegalArgumentException("-o switch requires an output file name");
                }
                outputFile = new File(args[++i]);
                continue;
            }
            if ("-c".equals(arg)) {
                detectCollisionsOnly = true;
                continue;
            }
            File file = new File(arg);
            if (!file.canRead()) {
                throw new IllegalArgumentException("Unable to read the index file: " + file);
            }
            if (file.isFile()) {
                indexFiles.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            Collections.addAll(indexFiles, file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && !pathname.isHidden();
                }
            }));
        }
        if (outputFile == null) {
            throw new IllegalStateException("The output file must be specified!");
        }
        LogMessageIndexDiff generator = new LogMessageIndexDiff();
        generator.createDiffFile(outputFile, generator.generate(indexFiles, detectCollisionsOnly));
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar weld-logging-tools-shaded.jar [-c] -o file-name FILEORDIR...");
        System.out.println("Options:");
        System.out.println("  -c  detect only collisions");
        System.out.println("  -o  name the output diff file");
    }

    public JsonObject generate(List<File> indexFiles, boolean detectCollisionsOnly) {
        if (indexFiles.size() < 2) {
            throw new IllegalStateException("More than one index file must be specified: " + indexFiles);
        }
        List<JsonObject> indexes = this.parseIndexFiles(indexFiles);
        JsonArray indexesMeta = new JsonArray();
        ArrayList<String> indexesIds = new ArrayList<String>();
        HashSet<JsonElement> versions = new HashSet<JsonElement>();
        for (JsonObject index : indexes) {
            JsonElement version = index.get("version");
            versions.add(version);
            String indexId = version.getAsString() + index.get("artifact").getAsString();
            if (indexesIds.contains(indexId)) {
                throw new IllegalStateException("Unable to compare index files with the same composite identifier (version and artifact id): " + indexId);
            }
            indexesIds.add(indexId);
            JsonObject indexMeta = new JsonObject();
            indexMeta.add("version", version);
            indexMeta.add("artifact", index.get("artifact"));
            indexMeta.add("total", index.get("total"));
            indexMeta.add("filePath", index.get("filePath"));
            indexesMeta.add(indexMeta);
        }
        JsonArray differences = this.findDifferences(versions.size(), detectCollisionsOnly, this.buildDataMap(indexes));
        JsonObject diff = new JsonObject();
        diff.add("indexes", indexesMeta);
        diff.add("detectCollisionsOnly", Json.wrapPrimitive(detectCollisionsOnly));
        diff.add("total", Json.wrapPrimitive(differences.size()));
        diff.add("differences", differences.size() > 0 ? differences : JsonNull.INSTANCE);
        return diff;
    }

    public void createDiffFile(File outputFile, JsonObject diff) {
        try {
            Json.writeJsonElementToFile(diff, this.initOutputFile(outputFile));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write the diff file", e);
        }
    }

    private List<JsonObject> parseIndexFiles(List<File> indexFiles) {
        ArrayList<JsonObject> indexes = new ArrayList<JsonObject>();
        for (File indexFile : indexFiles) {
            try {
                JsonObject index = Json.readJsonElementFromFile(indexFile).getAsJsonObject();
                index.add("filePath", Json.wrapPrimitive(indexFile.toPath().toString()));
                indexes.add(index);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to parse the index file: " + indexFile, e);
            }
        }
        Collections.sort(indexes, new Comparator<JsonObject>(){

            @Override
            public int compare(JsonObject o1, JsonObject o2) {
                int result = o1.get("version").getAsString().compareTo(o2.get("version").getAsString());
                return result == 0 ? o1.get("artifact").getAsString().compareTo(o2.get("artifact").getAsString()) : result;
            }
        });
        return indexes;
    }

    private Map<String, Map<Integer, Map<String, List<JsonObject>>>> buildDataMap(List<JsonObject> indexes) {
        HashMap<String, Map<Integer, Map<String, List<JsonObject>>>> dataMap = new HashMap<String, Map<Integer, Map<String, List<JsonObject>>>>();
        for (JsonObject index : indexes) {
            String version = index.get("version").getAsString();
            for (JsonElement messageElement : index.get("messages").getAsJsonArray()) {
                JsonObject message = messageElement.getAsJsonObject();
                String projectCode = message.get("projectCode").getAsString();
                TreeMap idMap = (TreeMap)dataMap.get(projectCode);
                if (idMap == null) {
                    idMap = new TreeMap();
                    dataMap.put(projectCode, idMap);
                }
                int id = message.get("msg").getAsJsonObject().get("id").getAsInt();
                HashMap<String, ArrayList<JsonObject>> versionMap = (HashMap<String, ArrayList<JsonObject>>)idMap.get(id);
                ArrayList<JsonObject> messages = null;
                if (versionMap == null) {
                    versionMap = new HashMap<String, ArrayList<JsonObject>>();
                    idMap.put(id, versionMap);
                } else {
                    messages = (ArrayList<JsonObject>)versionMap.get(version);
                }
                if (messages == null) {
                    messages = new ArrayList<JsonObject>();
                    versionMap.put(version, messages);
                }
                messages.add(message);
            }
        }
        return dataMap;
    }

    private JsonArray findDifferences(int indexCount, boolean detectCollisionsOnly, Map<String, Map<Integer, Map<String, List<JsonObject>>>> dataMap) {
        JsonArray differences = new JsonArray();
        for (Map.Entry<String, Map<Integer, Map<String, List<JsonObject>>>> entry : dataMap.entrySet()) {
            for (Map.Entry<Integer, Map<String, List<JsonObject>>> idEntry : entry.getValue().entrySet()) {
                if (!this.isDifference(indexCount, detectCollisionsOnly, idEntry.getValue())) continue;
                JsonObject difference = new JsonObject();
                difference.add("projectCode", Json.wrapPrimitive(entry.getKey()));
                difference.add("id", Json.wrapPrimitive(idEntry.getKey()));
                JsonArray messages = new JsonArray();
                for (Map.Entry<String, List<JsonObject>> versionEntry : idEntry.getValue().entrySet()) {
                    for (JsonObject message : versionEntry.getValue()) {
                        messages.add(this.wrap(versionEntry.getKey(), message));
                    }
                }
                difference.add("messages", messages);
                differences.add(difference);
            }
        }
        return differences;
    }

    private boolean isDifference(int indexCount, boolean detectCollisionsOnly, Map<String, List<JsonObject>> versionMap) {
        if (!detectCollisionsOnly && indexCount != versionMap.size()) {
            return true;
        }
        ArrayList<List<JsonObject>> values = new ArrayList<List<JsonObject>>(versionMap.values());
        for (int i = 1; i < values.size(); ++i) {
            List current = (List)values.get(i);
            List previous = (List)values.get(i - 1);
            if (!detectCollisionsOnly && current.size() != previous.size()) {
                return true;
            }
            if (current.size() == 1) {
                return !((JsonObject)current.get(0)).equals(previous.get(0));
            }
            if (current.containsAll(previous)) continue;
            return true;
        }
        return false;
    }

    private File initOutputFile(File outputFile) {
        if (!outputFile.exists()) {
            try {
                outputFile.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create the output file: " + outputFile);
            }
        }
        if (!outputFile.canWrite()) {
            throw new IllegalStateException("Unable to write to the output file: " + outputFile);
        }
        return outputFile;
    }

    private JsonObject wrap(String version, JsonElement element) {
        JsonObject versionAware = new JsonObject();
        versionAware.add("version", Json.wrapPrimitive(version));
        versionAware.add("value", element);
        return versionAware;
    }
}

