/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.PathTemplateLocator;
import org.trimou.engine.locator.SecurityActions;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Files;

public class ClassPathTemplateLocator
extends PathTemplateLocator<String> {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathTemplateLocator.class);
    private final ClassLoader classLoader;
    private final boolean scanClasspath;

    public ClassPathTemplateLocator(int priority, String rootPath) {
        this(priority, rootPath, null, null, true);
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix) {
        this(priority, rootPath, suffix, null, true);
    }

    public ClassPathTemplateLocator(int priority, String rootPath, ClassLoader classLoader) {
        this(priority, rootPath, null, classLoader, true);
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix, ClassLoader classLoader, boolean scanClasspath) {
        super(priority, rootPath, suffix);
        if (classLoader == null && (classLoader = SecurityActions.getContextClassLoader()) == null) {
            classLoader = SecurityActions.getClassLoader(ClassPathTemplateLocator.class);
        }
        this.classLoader = classLoader;
        this.scanClasspath = scanClasspath;
    }

    @Override
    public Reader locate(String templateId) {
        return this.locateRealPath(this.toRealPath(templateId));
    }

    @Override
    public Set<String> getAllIdentifiers() {
        if (!this.scanClasspath || this.getRootPath() == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try {
            Enumeration<URL> resources = this.classLoader.getResources(this.getRootPath());
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if ("file".equals(resource.getProtocol())) {
                    try {
                        List<File> files;
                        File root = Paths.get(resource.toURI()).toFile();
                        if (!Files.isDirectoryUsable(root) || (files = Files.listFiles(root, this.getSuffix())).isEmpty()) continue;
                        for (File file : files) {
                            if (!Files.isFileUsable(file)) continue;
                            String id = this.stripSuffix(this.constructVirtualPath(root, file));
                            builder.add(id);
                            logger.debug("Template available: {}", (Object)id);
                        }
                        continue;
                    }
                    catch (URISyntaxException e) {
                        logger.warn("Unable to process root path: {}", (Object)resource, (Object)e);
                        continue;
                    }
                }
                logger.debug("Protocol not supported - root resource is ignored: {}", (Object)resource);
            }
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
        return builder.build();
    }

    @Override
    protected String constructVirtualPath(String source) {
        throw new UnsupportedOperationException();
    }

    private Reader locateRealPath(String realPath) {
        String name = this.getRootPath() != null ? this.getRootPath() + this.addSuffix(realPath) : this.addSuffix(realPath);
        InputStreamReader reader = null;
        try {
            Enumeration<URL> resources = this.classLoader.getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (reader != null) {
                    logger.warn("Another/duplicit template for {} ignored: {}", (Object)name, (Object)resource);
                    continue;
                }
                reader = new InputStreamReader(resource.openStream(), this.getDefaultFileEncoding());
                logger.debug("Template {} located: {}", (Object)name, (Object)resource);
            }
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
        return reader;
    }

    private String constructVirtualPath(File root, File source) {
        File parent = source.getParentFile();
        ArrayList<String> parts = new ArrayList<String>();
        if (parent == null) {
            throw new IllegalStateException("Unable to construct virtual path - no parent directory found");
        }
        parts.add(source.getName());
        while (!root.equals(parent)) {
            parts.add(parent.getName());
            parent = parent.getParentFile();
        }
        Collections.reverse(parts);
        StringBuilder name = new StringBuilder();
        Iterator iterator = parts.iterator();
        while (iterator.hasNext()) {
            name.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            name.append(this.getVirtualPathSeparator());
        }
        return name.toString();
    }

    public static Builder builder(int priority) {
        return new Builder(priority);
    }

    public static class Builder {
        private ClassLoader classLoader;
        private int priority;
        private String rootPath;
        private String suffix;
        private boolean scanClasspath = true;

        private Builder(int priority) {
            this.priority = priority;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder setScanClasspath(boolean scanClasspath) {
            this.scanClasspath = scanClasspath;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public ClassPathTemplateLocator build() {
            ClassLoader cl;
            if (this.classLoader != null) {
                cl = this.classLoader;
            } else {
                cl = SecurityActions.getContextClassLoader();
                if (cl == null) {
                    cl = ClassPathTemplateLocator.class.getClassLoader();
                }
            }
            return new ClassPathTemplateLocator(this.priority, this.rootPath, this.suffix, cl, this.scanClasspath);
        }
    }
}

