/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import com.google.common.collect.Lists;
import java.util.List;
import org.trimou.Mustache;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ExecutionContexts;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.engine.resource.AbstractReleaseCallbackContainer;
import org.trimou.engine.segment.RootSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class Template
implements Mustache {
    private final long generatedId;
    private final String name;
    private final MustacheEngine engine;
    private final ExecutionContext globalExecutionContext;
    private volatile RootSegment rootSegment;

    public Template(Long generatedId, String name, MustacheEngine engine) {
        this.generatedId = generatedId;
        this.name = name;
        this.engine = engine;
        this.globalExecutionContext = ExecutionContexts.newGlobalExecutionContext(engine.getConfiguration());
    }

    @Override
    public Long getGeneratedId() {
        return this.generatedId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String render(Object data) {
        StringBuilder builder = new StringBuilder();
        this.render(builder, data);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Appendable appendable, Object data) {
        DefaultMustacheRenderingEvent event = new DefaultMustacheRenderingEvent(this.name, this.generatedId, this.engine.getConfiguration().getIdentifierGenerator().generate(MustacheRenderingEvent.class));
        try {
            this.renderingStarted(event);
            appendable = this.rootSegment.execute(appendable, data != null ? this.globalExecutionContext.setContextObject(data) : this.globalExecutionContext);
            RootSegment.flushAsyncAppendable(appendable);
            this.renderingFinished(event);
        }
        finally {
            event.release();
        }
    }

    public RootSegment getRootSegment() {
        return this.rootSegment;
    }

    void setRootSegment(RootSegment rootSegment) {
        if (this.rootSegment != null) {
            throw new MustacheException(MustacheProblem.TEMPLATE_MODIFICATION_NOT_ALLOWED);
        }
        this.rootSegment = rootSegment;
    }

    public MustacheEngine getEngine() {
        return this.engine;
    }

    private void renderingStarted(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners != null) {
            for (MustacheListener listener : listeners) {
                listener.renderingStarted(event);
            }
        }
    }

    private void renderingFinished(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners != null) {
            for (MustacheListener listener : Lists.reverse(listeners)) {
                listener.renderingFinished(event);
            }
        }
    }

    public String toString() {
        return String.format("Template %s", this.name);
    }

    private static final class DefaultMustacheRenderingEvent
    extends AbstractReleaseCallbackContainer
    implements MustacheRenderingEvent {
        private final String mustacheName;
        private final long mustacheId;
        private final long generatedId;

        public DefaultMustacheRenderingEvent(String mustacheName, long mustacheId, long sequenceValue) {
            this.mustacheName = mustacheName;
            this.mustacheId = mustacheId;
            this.generatedId = sequenceValue;
        }

        @Override
        public String getMustacheName() {
            return this.mustacheName;
        }

        @Override
        public long getMustacheGeneratedId() {
            return this.mustacheId;
        }

        @Override
        public Long getGeneratedId() {
            return this.generatedId;
        }
    }
}

