/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.FieldWrapper;
import org.trimou.engine.resolver.Hints;
import org.trimou.engine.resolver.MemberKey;
import org.trimou.engine.resolver.MemberWrapper;
import org.trimou.engine.resolver.MethodWrapper;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.SecurityActions;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Reflections;

public class ReflectionResolver
extends AbstractResolver
implements RemovalListener<MemberKey, Optional<MemberWrapper>> {
    public static final int REFLECTION_RESOLVER_PRIORITY = Priorities.rightBefore(10);
    public static final String COMPUTING_CACHE_CONSUMER_ID = ReflectionResolver.class.getName();
    public static final ConfigurationKey MEMBER_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".memberCacheMaxSize", 10000L);
    public static final ConfigurationKey HINT_FALLBACK_ENABLED_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".hintFallbackEnabled", true);
    private static final Logger logger = LoggerFactory.getLogger(ReflectionResolver.class);
    private ComputingCache<MemberKey, Optional<MemberWrapper>> memberCache;
    private boolean hintFallbackEnabled;

    public ReflectionResolver() {
        this(REFLECTION_RESOLVER_PRIORITY);
    }

    public ReflectionResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null) {
            return null;
        }
        MemberKey key = MemberKey.newInstance(contextObject, name);
        MemberWrapper wrapper = this.memberCache != null ? this.memberCache.get(key).orNull() : ReflectionResolver.findWrapper(key).orNull();
        if (wrapper == null) {
            return null;
        }
        try {
            return wrapper.getValue(contextObject);
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_REFLECT_INVOCATION_ERROR, (Throwable)e);
        }
    }

    @Override
    public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
        Optional<MemberWrapper> found;
        MemberKey key = MemberKey.newInstance(contextObject, name);
        MemberWrapper wrapper = this.memberCache != null ? ((found = this.memberCache.getIfPresent(key)) != null ? found.get() : null) : ReflectionResolver.findWrapper(key).orNull();
        if (wrapper != null) {
            return new ReflectionHint(key, wrapper);
        }
        return Hints.INAPPLICABLE_HINT;
    }

    @Override
    public void init() {
        long memberCacheMaxSize = this.configuration.getLongPropertyValue(MEMBER_CACHE_MAX_SIZE_KEY);
        logger.debug("Initialized [memberCacheMaxSize: {}]", (Object)memberCacheMaxSize);
        if (memberCacheMaxSize > 0L) {
            this.memberCache = this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, new MemberComputingFunction(), null, memberCacheMaxSize, null);
        }
        this.hintFallbackEnabled = this.configuration.getBooleanPropertyValue(HINT_FALLBACK_ENABLED_KEY);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(MEMBER_CACHE_MAX_SIZE_KEY);
    }

    @Override
    public void onRemoval(RemovalNotification<MemberKey, Optional<MemberWrapper>> notification) {
    }

    public void invalidateMemberCache(final Predicate<Class<?>> predicate) {
        if (this.memberCache == null) {
            return;
        }
        if (predicate == null) {
            this.memberCache.clear();
        } else {
            this.memberCache.invalidate(new ComputingCache.KeyPredicate<MemberKey>(){

                @Override
                public boolean apply(MemberKey key) {
                    return predicate.apply(key.getClazz());
                }
            });
        }
    }

    long getMemberCacheSize() {
        return this.memberCache != null ? this.memberCache.size() : 0L;
    }

    private static Optional<MemberWrapper> findWrapper(MemberKey key) {
        Method foundMethod = Reflections.findMethod(key.getClazz(), key.getName());
        if (foundMethod != null) {
            if (!foundMethod.isAccessible()) {
                SecurityActions.setAccessible(foundMethod);
            }
            return Optional.of(new MethodWrapper(foundMethod));
        }
        Field foundField = Reflections.findField(key.getClazz(), key.getName());
        if (foundField != null) {
            if (!foundField.isAccessible()) {
                SecurityActions.setAccessible(foundField);
            }
            return Optional.of(new FieldWrapper(foundField));
        }
        return Optional.absent();
    }

    private class ReflectionHint
    implements EnhancedResolver.Hint {
        private final MemberKey key;
        private final MemberWrapper wrapper;

        ReflectionHint(MemberKey key, MemberWrapper wrapper) {
            this.key = key;
            this.wrapper = wrapper;
        }

        @Override
        public Object resolve(Object contextObject, String name, ResolutionContext context) {
            if (contextObject == null) {
                return null;
            }
            if (this.key.getClazz().equals(contextObject.getClass())) {
                try {
                    return this.wrapper.getValue(contextObject);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (ReflectionResolver.this.hintFallbackEnabled) {
                return ReflectionResolver.this.resolve(contextObject, name, context);
            }
            return null;
        }
    }

    private static class MemberComputingFunction
    implements ComputingCache.Function<MemberKey, Optional<MemberWrapper>> {
        private MemberComputingFunction() {
        }

        @Override
        public Optional<MemberWrapper> compute(MemberKey key) {
            return ReflectionResolver.findWrapper(key);
        }
    }
}

