/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AsyncAppendable;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.HelperValidator;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;

class HelperExecutionHandler {
    private final Helper helper;
    private final OptionsBuilder optionsBuilder;

    private HelperExecutionHandler(Helper helper, OptionsBuilder optionsBuilder) {
        this.helper = helper;
        this.optionsBuilder = optionsBuilder;
    }

    static HelperExecutionHandler from(String name, MustacheEngine engine, HelperAwareSegment segment) {
        Iterator<String> parts = HelperValidator.splitHelperName(name, segment);
        Helper helper = engine.getConfiguration().getHelpers().get(parts.next());
        if (helper == null) {
            return null;
        }
        ImmutableList.Builder params = ImmutableList.builder();
        ImmutableMap.Builder<String, Object> hash = ImmutableMap.builder();
        while (parts.hasNext()) {
            String part = parts.next();
            int position = HelperValidator.getFirstDeterminingEqualsCharPosition(part);
            if (position != -1) {
                hash.put(part.substring(0, position), HelperExecutionHandler.getLiteralOrPlaceholder(part.substring(position + 1, part.length()), engine, segment));
                continue;
            }
            params.add(HelperExecutionHandler.getLiteralOrPlaceholder(part, engine, segment));
        }
        OptionsBuilder optionsBuilder = new OptionsBuilder((List)((Object)params.build()), hash.build(), segment, engine);
        helper.validate(optionsBuilder);
        return new HelperExecutionHandler(helper, optionsBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Appendable execute(Appendable appendable, ExecutionContext executionContext) {
        DefaultOptions options = this.optionsBuilder.build(appendable, executionContext);
        try {
            this.helper.execute(options);
            Appendable appendable2 = options.getAppendable();
            return appendable2;
        }
        finally {
            options.release();
        }
    }

    private static Object getLiteralOrPlaceholder(String value, MustacheEngine engine, HelperAwareSegment segment) {
        Object literal = engine.getConfiguration().getLiteralSupport().getLiteral(value, segment.getTagInfo());
        return literal != null ? literal : new DefaultValuePlaceholder(value);
    }

    private static class DefaultValuePlaceholder
    implements HelperDefinition.ValuePlaceholder {
        private final String name;

        public DefaultValuePlaceholder(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class DefaultOptions
    implements Options {
        private static final Logger logger = LoggerFactory.getLogger(DefaultOptions.class);
        protected final List<ValueWrapper> valueWrappers;
        protected Appendable appendable;
        protected int pushed;
        protected ExecutionContext executionContext;
        private final MustacheEngine engine;
        private final HelperAwareSegment segment;
        private final List<Object> parameters;
        private final Map<String, Object> hash;

        DefaultOptions(Appendable appendable, ExecutionContext executionContext, HelperAwareSegment segment, List<Object> parameters, Map<String, Object> hash, List<ValueWrapper> valueWrappers, MustacheEngine engine) {
            this.appendable = appendable;
            this.valueWrappers = valueWrappers;
            this.executionContext = executionContext;
            this.pushed = 0;
            this.executionContext = executionContext;
            this.segment = segment;
            this.parameters = parameters;
            this.hash = hash;
            this.engine = engine;
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public void append(CharSequence sequence) {
            try {
                this.appendable.append(sequence);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void fn() {
            this.appendable = this.segment.fn(this.appendable, this.executionContext);
        }

        @Override
        public void partial(String templateId) {
            this.partial(templateId, this.appendable);
        }

        @Override
        public void push(Object contextObject) {
            ++this.pushed;
            this.executionContext = this.executionContext.setContextObject(contextObject);
        }

        @Override
        public Object pop() {
            if (this.pushed > 0) {
                --this.pushed;
                Object top = this.executionContext.getFirstContextObject();
                this.executionContext = this.executionContext.getParent();
                return top;
            }
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_POP_OPERATION);
        }

        @Override
        public Object peek() {
            return this.executionContext.getFirstContextObject();
        }

        @Override
        public Object getValue(String key) {
            ValueWrapper wrapper = this.executionContext.getValue(key);
            this.valueWrappers.add(wrapper);
            return wrapper.get();
        }

        @Override
        public void partial(String templateId, Appendable appendable) {
            this.partial(templateId, appendable, this.executionContext);
        }

        @Override
        public void executeAsync(final Options.HelperExecutable executable) {
            final AsyncAppendable asyncAppendable = new AsyncAppendable(this.appendable);
            ExecutorService executor = this.engine.getConfiguration().geExecutorService();
            if (executor == null) {
                throw new MustacheException(MustacheProblem.RENDER_ASYNC_PROCESSING_ERROR, "ExecutorService must be set in order to submit an asynchronous task", new Object[0]);
            }
            Future<AsyncAppendable> future = executor.submit(new Callable<AsyncAppendable>(){

                @Override
                public AsyncAppendable call() throws Exception {
                    DefaultOptions asyncOptions = new DefaultOptions(new AsyncAppendable(asyncAppendable), DefaultOptions.this.executionContext, DefaultOptions.this.segment, DefaultOptions.this.parameters, DefaultOptions.this.hash, new ArrayList<ValueWrapper>(), DefaultOptions.this.engine);
                    executable.execute(asyncOptions);
                    return (AsyncAppendable)asyncOptions.getAppendable();
                }
            });
            asyncAppendable.setFuture(future);
            this.appendable = asyncAppendable;
        }

        @Override
        public String source(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            String mustacheSource = this.engine.getMustacheSource(templateId);
            if (mustacheSource == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No mustache template found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            return mustacheSource;
        }

        @Override
        public Appendable getAppendable() {
            return this.appendable;
        }

        @Override
        public void fn(Appendable appendable) {
            this.segment.fn(appendable, this.executionContext);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        protected void partial(String templateId, Appendable appendable, ExecutionContext executionContext) {
            Checker.checkArgumentsNotNull(templateId, appendable);
            Template partialTemplate = (Template)this.engine.getMustache(templateId);
            if (partialTemplate == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            partialTemplate.getRootSegment().execute(appendable, executionContext);
        }

        void release() {
            int wrappersSize = this.valueWrappers.size();
            if (wrappersSize == 1) {
                this.valueWrappers.get(0).release();
            } else if (wrappersSize > 1) {
                for (ValueWrapper wrapper : this.valueWrappers) {
                    wrapper.release();
                }
            }
            if (this.pushed > 0) {
                logger.info("{} remaining objects pushed on the context stack will be automatically garbage collected [helperName: {}, template: {}]", this.pushed, HelperValidator.splitHelperName(this.segment.getTagInfo().getText(), this.segment).next(), this.segment.getTagInfo().getTemplateName());
            }
        }
    }

    private static class OptionsBuilder
    implements HelperDefinition {
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final HelperAwareSegment segment;
        private final MustacheEngine engine;
        private final boolean isParamValuePlaceholderFound;
        private final boolean isHashValuePlaceholderFound;

        private OptionsBuilder(List<Object> parameters, Map<String, Object> hash, HelperAwareSegment segment, MustacheEngine engine) {
            this.parameters = parameters;
            this.hash = hash;
            this.segment = segment;
            this.engine = engine;
            this.isParamValuePlaceholderFound = this.initParamValuePlaceholderFound(parameters);
            this.isHashValuePlaceholderFound = this.initHashValuePlaceholderFound(hash);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        public DefaultOptions build(Appendable appendable, ExecutionContext executionContext) {
            Map<String, Object> finalHash;
            List<Object> finalParams;
            int size;
            ArrayList<ValueWrapper> valueWrappers = new ArrayList<ValueWrapper>();
            if (this.isParamValuePlaceholderFound) {
                size = this.parameters.size();
                switch (size) {
                    case 1: {
                        finalParams = Collections.singletonList(this.resolveValue(this.parameters.get(0), valueWrappers, executionContext));
                        break;
                    }
                    default: {
                        finalParams = new ArrayList<Object>(size);
                        for (Object param : this.parameters) {
                            finalParams.add(this.resolveValue(param, valueWrappers, executionContext));
                        }
                        finalParams = Collections.unmodifiableList(finalParams);
                        break;
                    }
                }
            } else {
                finalParams = this.parameters;
            }
            if (this.isHashValuePlaceholderFound) {
                size = this.hash.size();
                switch (size) {
                    case 1: {
                        Map.Entry<String, Object> singleEntry = this.hash.entrySet().iterator().next();
                        finalHash = Collections.singletonMap(singleEntry.getKey(), this.resolveValue(singleEntry.getValue(), valueWrappers, executionContext));
                        break;
                    }
                    default: {
                        finalHash = new HashMap<String, Object>();
                        for (Map.Entry<String, Object> entry : this.hash.entrySet()) {
                            finalHash.put(entry.getKey(), this.resolveValue(entry.getValue(), valueWrappers, executionContext));
                        }
                        finalHash = Collections.unmodifiableMap(finalHash);
                        break;
                    }
                }
            } else {
                finalHash = this.hash;
            }
            return new DefaultOptions(appendable, executionContext, this.segment, finalParams, finalHash, valueWrappers, this.engine);
        }

        private Object resolveValue(Object value, List<ValueWrapper> valueWrappers, ExecutionContext executionContext) {
            if (value instanceof HelperDefinition.ValuePlaceholder) {
                ValueWrapper wrapper = executionContext.getValue(((HelperDefinition.ValuePlaceholder)value).getName());
                valueWrappers.add(wrapper);
                return wrapper.get();
            }
            return value;
        }

        private boolean initParamValuePlaceholderFound(List<Object> parameters) {
            if (parameters.isEmpty()) {
                return false;
            }
            for (Object param : parameters) {
                if (!(param instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }

        private boolean initHashValuePlaceholderFound(Map<String, Object> hash) {
            if (hash.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : hash.entrySet()) {
                if (!(entry.getValue() instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }
    }
}

