/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.util.Strings;

final class Segments {
    private Segments() {
    }

    static boolean isTemplateCachingAllowed(Configuration configuration) {
        return configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE) == false && configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_ENABLED) != false && configuration.getLongPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Template getTemplate(AtomicReference<Template> cachedReference, String templateId, MustacheEngine engine) {
        if (cachedReference != null) {
            Template template = cachedReference.get();
            if (template == null) {
                AtomicReference<Template> atomicReference = cachedReference;
                synchronized (atomicReference) {
                    if (template == null) {
                        template = (Template)engine.getMustache(templateId);
                        cachedReference.set(template);
                    }
                }
            }
            return template;
        }
        return (Template)engine.getMustache(templateId);
    }

    static List<List<Segment>> readSegmentLinesBeforeRendering(AbstractContainerSegment container) {
        ArrayList<List<Segment>> lines = new ArrayList<List<Segment>>();
        ArrayList<Segment> currentLine = new ArrayList<Segment>();
        for (Segment segment : container) {
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList();
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    static List<Segment> readSegmentLines(List<List<Segment>> lines, List<Segment> currentLine, AbstractContainerSegment container) {
        if (currentLine == null) {
            currentLine = new ArrayList<Segment>();
        }
        if (!SegmentType.ROOT.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        for (Segment segment : container) {
            if (segment instanceof AbstractContainerSegment) {
                currentLine = Segments.readSegmentLines(lines, currentLine, (AbstractContainerSegment)segment);
                continue;
            }
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList<Segment>();
        }
        if (!SegmentType.ROOT.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        return currentLine;
    }

    static String getSegmentTree(AbstractContainerSegment container) {
        return Segments.getSegmentTreeInternal(1, container);
    }

    private static String getSegmentTreeInternal(int level, AbstractContainerSegment container) {
        StringBuilder tree = new StringBuilder();
        tree.append(Strings.LINE_SEPARATOR);
        if (level > 1) {
            tree.append(StringUtils.repeat(" ", level - 1));
        }
        tree.append("+");
        if (!SegmentType.ROOT.equals((Object)container.getType())) {
            tree.append(container.getTemplate().getName());
            tree.append(":");
        }
        tree.append((Object)container.getType());
        tree.append(":");
        tree.append(container.getText());
        for (Segment segment : container.getSegments()) {
            if (segment instanceof AbstractContainerSegment) {
                tree.append(Segments.getSegmentTreeInternal(level + 1, (AbstractContainerSegment)segment));
                continue;
            }
            tree.append(Strings.LINE_SEPARATOR);
            tree.append(StringUtils.repeat(" ", level));
            tree.append("-");
            tree.append(segment.getOrigin().getTemplateName());
            tree.append(":");
            tree.append((Object)segment.getType());
            if (!segment.getType().hasName()) continue;
            tree.append(":");
            tree.append(segment.getText());
        }
        return tree.toString();
    }
}

