/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.i18n.LocaleAwareValueHelper;
import org.trimou.util.Arrays;

public class ResourceBundleHelper
extends LocaleAwareValueHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBundleHelper.class);
    private static final Set<String> SUPPORTED_HASH_KEYS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("format")).add("baseName")).add("locale")).build();
    private final String defaultBaseName;
    private final Format defaultFormat;

    public ResourceBundleHelper(String defaultBaseName) {
        this(defaultBaseName, Format.PRINTF);
    }

    public ResourceBundleHelper(String defaultBaseName, Format defaultFormat) {
        this.defaultBaseName = defaultBaseName;
        this.defaultFormat = defaultFormat;
    }

    @Override
    public void execute(Options options) {
        String key = options.getParameters().get(0).toString();
        Object baseName = this.getHashValue(options, "baseName");
        ResourceBundle bundle = ResourceBundle.getBundle(baseName != null ? baseName.toString() : this.defaultBaseName, this.getLocale(options));
        if (bundle.containsKey(key)) {
            Format format = this.getFormat(options.getHash());
            String stringValue = bundle.getString(key);
            if (Format.NO_FORMAT.equals((Object)format)) {
                this.append(options, stringValue);
            } else {
                Object[] formatParams = this.getFormatParams(options.getParameters());
                try {
                    if (Format.PRINTF.equals((Object)format)) {
                        this.append(options, String.format(bundle.getString(key), formatParams));
                    } else if (Format.MESSAGE.equals((Object)format)) {
                        this.append(options, MessageFormat.format(bundle.getString(key), formatParams));
                    }
                }
                catch (Exception e) {
                    throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
                }
            }
        }
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of(SUPPORTED_HASH_KEYS);
    }

    private Format getFormat(Map<String, Object> hash) {
        if (hash.isEmpty() || !hash.containsKey("format")) {
            return this.defaultFormat;
        }
        String customFormat = hash.get("format").toString();
        Format format = Format.parse(customFormat);
        if (format == null) {
            logger.warn("Unsupported format specified: {}, using the default one: {}", (Object)customFormat, (Object)this.defaultFormat.getValue());
            format = this.defaultFormat;
        }
        return format;
    }

    private Object[] getFormatParams(List<Object> params) {
        if (params.size() > 1) {
            return params.subList(1, params.size()).toArray();
        }
        return Arrays.EMPTY_OBJECT_ARRAY;
    }

    public static enum Format {
        PRINTF("printf"),
        MESSAGE("message"),
        NO_FORMAT("none");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static Format parse(String value) {
            for (Format format : Format.values()) {
                if (!value.equals(format.value)) continue;
                return format;
            }
            return null;
        }
    }
}

