/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.trimou.annotations.Internal;

@Internal
public final class Checker {
    private static final Long LONG_ZERO = 0L;
    private static final Integer INTEGER_ZERO = 0;
    private static final Short SHORT_ZERO = 0;
    private static final Byte BYTE_ZERO = 0;
    private static final Double DOUBLE_ZERO = 0.0;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);

    private Checker() {
    }

    public static void checkArgumentsNotNull(Object ... arguments) {
        for (Object argument : arguments) {
            Checker.checkArgumentNotNull(argument);
        }
    }

    public static void checkArgumentNotNull(Object argument) {
        Preconditions.checkArgument(argument != null, "Argument must not be null");
    }

    public static void checkArgumentNotEmpty(String argument) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(argument));
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isFalsy(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof Number) {
            return Checker.isZero((Number)value);
        }
        return false;
    }

    private static boolean isZero(Number number) {
        if (number instanceof BigDecimal) {
            return BigDecimal.ZERO.compareTo((BigDecimal)number) == 0;
        }
        return INTEGER_ZERO.equals(number) || LONG_ZERO.equals(number) || SHORT_ZERO.equals(number) || BYTE_ZERO.equals(number) || DOUBLE_ZERO.equals(number) || FLOAT_ZERO.equals(number) || BigInteger.ZERO.equals(number);
    }
}

