/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;
import org.trimou.util.SecurityActions;

@Internal
public final class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";

    private Reflections() {
    }

    public static Method findMethod(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Method foundMatch = null;
        Method foundGetMatch = null;
        Method foundIsMatch = null;
        for (Method method : SecurityActions.getMethods(clazz)) {
            if (!Reflections.isMethodValid(method)) continue;
            if (method.isBridge()) {
                logger.debug("Skipping bridge method {}", (Object)method);
                continue;
            }
            if (name.equals(method.getName())) {
                foundMatch = method;
                continue;
            }
            if (Reflections.matchesPrefix(name, method.getName(), GET_PREFIX)) {
                foundGetMatch = method;
                continue;
            }
            if (!Reflections.matchesPrefix(name, method.getName(), IS_PREFIX)) continue;
            foundIsMatch = method;
        }
        if (foundMatch == null) {
            foundMatch = foundGetMatch != null ? foundGetMatch : foundIsMatch;
        }
        logger.debug("{} method {}found [type: {}]", name, foundMatch != null ? "" : "not ", clazz.getName());
        return foundMatch;
    }

    public static Field findField(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Field found = null;
        for (Field field : SecurityActions.getFields(clazz)) {
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        logger.debug("{} field {}found [type: {}]", name, found != null ? "" : "not ", clazz.getName());
        return found;
    }

    public static boolean isMethodValid(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !Object.class.equals(method.getDeclaringClass());
    }

    public static Set<Method> getMethods(Class<?> clazz) {
        Checker.checkArgumentNotNull(clazz);
        HashSet<Method> found = new HashSet<Method>();
        for (Method method : SecurityActions.getMethods(clazz)) {
            if (!Reflections.isMethodValid(method)) continue;
            if (method.isBridge()) {
                logger.warn("Skipping bridge method {0}", (Object)method);
                continue;
            }
            found.add(method);
        }
        logger.debug("{} methods found [type: {}]", new Object[]{found.size(), clazz.getName()});
        return found;
    }

    public static Set<Field> getFields(Class<?> clazz) {
        Checker.checkArgumentNotNull(clazz);
        HashSet<Field> found = new HashSet<Field>();
        for (Field field : SecurityActions.getFields(clazz)) {
            found.add(field);
        }
        logger.debug("{} field found [type: {}]", new Object[]{found.size(), clazz.getName()});
        return found;
    }

    public static String decapitalize(String methodName, String prefix) {
        return Introspector.decapitalize(methodName.substring(prefix.length(), methodName.length()));
    }

    private static boolean matchesPrefix(String name, String methodName, String prefix) {
        return methodName.startsWith(prefix) && Reflections.decapitalize(methodName, prefix).equals(name);
    }
}

