/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.jboss.weld.logging.Files;
import org.jboss.weld.logging.Json;

@SupportedAnnotationTypes(value={"org.jboss.logging.annotations.Message"})
@SupportedOptions(value={"projectVersion", "outputFile", "artifact"})
public class LogMessageIndexGenerator
extends AbstractProcessor {
    private File outputFile;
    private String version;
    private String artifact;
    private List<LogMessage> logMessages = new ArrayList<LogMessage>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.version = processingEnv.getOptions().get("projectVersion");
        if (this.version == null) {
            this.version = "UNKNOWN";
        }
        this.artifact = processingEnv.getOptions().get("artifact");
        if (this.artifact == null) {
            this.artifact = "UNKNOWN";
        }
        this.outputFile = this.initOutputFile(processingEnv.getOptions().get("outputFile"));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    this.processElement(element);
                }
            }
            if (roundEnv.processingOver() && this.logMessages.size() > 0) {
                this.createIndex();
            }
            return true;
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, stringWriter.toString());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processElement(Element element) {
        void var6_8;
        if (!ElementKind.METHOD.equals((Object)element.getKind())) {
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        Element enclosingElement = executableElement.getEnclosingElement();
        if (!ElementKind.INTERFACE.equals((Object)enclosingElement.getKind())) {
            return;
        }
        String projectCode = "";
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(enclosingElement)) {
            if (!"org.jboss.logging.annotations.MessageLogger".equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"projectCode".equals(entry.getKey().getSimpleName().toString())) continue;
                projectCode = entry.getValue().getValue().toString();
            }
        }
        JsonObject json = new JsonObject();
        json.add("projectCode", Json.wrapPrimitive(projectCode));
        Integer n = -1;
        JsonObject methodInfo = new JsonObject();
        methodInfo.add("sig", Json.wrapPrimitive(this.createMethodSignature(executableElement)));
        methodInfo.add("retType", Json.wrapPrimitive(executableElement.getReturnType().toString()));
        methodInfo.add("interface", Json.wrapPrimitive(enclosingElement.toString()));
        json.add("method", methodInfo);
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(executableElement)) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters = annotationMirror.getElementValues();
            if (annotationType.equals("org.jboss.logging.annotations.LogMessage")) {
                JsonObject logMessage = new JsonObject();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
                    logMessage.add(entry.getKey().getSimpleName().toString(), Json.wrapPrimitive(entry.getValue()));
                }
                json.add("log", logMessage);
                continue;
            }
            if (annotationType.equals("org.jboss.logging.annotations.Message")) {
                JsonObject message = new JsonObject();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
                    message.add(entry.getKey().getSimpleName().toString(), Json.wrapPrimitive(entry.getValue()));
                    if (!entry.getKey().getSimpleName().toString().equals("id")) continue;
                    Integer n2 = (Integer)entry.getValue().getValue();
                }
                json.add("msg", message);
                continue;
            }
            if (!annotationType.equals("java.lang.SuppressWarnings")) continue;
            JsonArray suppressions = new JsonArray();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                List values = (List)entry.getValue().getValue();
                for (AnnotationValue annotationValue : values) {
                    String value = annotationValue.getValue().toString();
                    if (!value.startsWith("weldlog:")) continue;
                    suppressions.add(Json.wrapPrimitive(value));
                }
            }
            json.add("suppressions", suppressions);
        }
        String comment = this.processingEnv.getElementUtils().getDocComment(element);
        if (comment != null) {
            int n3 = comment.indexOf(64);
            if (n3 != -1) {
                comment = comment.substring(0, n3).trim();
            }
            json.add("desc", Json.wrapPrimitive(comment));
        }
        this.logMessages.add(new LogMessage(var6_8.intValue(), json));
    }

    private void createIndex() throws IOException {
        if (!this.outputFile.exists()) {
            try {
                File parent = this.outputFile.getParentFile();
                if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                    throw new IOException("Parent directory could not be created: " + parent);
                }
                this.outputFile.createNewFile();
            }
            catch (IOException e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, writer.toString());
            }
        }
        if (!(this.outputFile.exists() && this.outputFile.isFile() && this.outputFile.canWrite())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The output index file does no exists, is not a file or is not writeable: " + this.outputFile);
        }
        JsonObject data = new JsonObject();
        data.add("version", Json.wrapPrimitive(this.version));
        data.add("artifact", Json.wrapPrimitive(this.artifact));
        data.add("total", Json.wrapPrimitive(this.logMessages.size()));
        Collections.sort(this.logMessages, new Comparator<LogMessage>(){

            @Override
            public int compare(LogMessage o1, LogMessage o2) {
                return Integer.compare(o1.getId(), o2.getId());
            }
        });
        JsonArray messages = new JsonArray();
        for (LogMessage message : this.logMessages) {
            messages.add(message.getJson());
        }
        data.add("messages", messages);
        Json.writeJsonElementToFile(data, this.outputFile);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Log message index generated [size: %s, file: %s]", this.logMessages.size(), this.outputFile));
    }

    private String createMethodSignature(ExecutableElement executableElement) {
        StringBuilder builder = new StringBuilder();
        builder.append(executableElement.getSimpleName());
        builder.append('(');
        Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
        while (iterator.hasNext()) {
            VariableElement param = iterator.next();
            List<? extends AnnotationMirror> annotations = param.getAnnotationMirrors();
            if (!annotations.isEmpty()) {
                for (AnnotationMirror annotationMirror : annotations) {
                    builder.append('@');
                    builder.append(annotationMirror.getAnnotationType().toString());
                    builder.append(' ');
                }
            }
            builder.append(param.asType().toString());
            builder.append(" ");
            builder.append(param.getSimpleName());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    private File initOutputFile(String outputFilePath) {
        if (outputFilePath == null) {
            outputFilePath = Files.getWorkingDirectory() + "target" + System.getProperty("file.separator") + "log-msg-idx_" + this.version + "_" + this.artifact.replaceAll("[^0-9a-zA-Z]", "-") + ".json";
        }
        return new File(outputFilePath);
    }

    static class LogMessage {
        private final int id;
        private final JsonObject json;

        LogMessage(int id, JsonObject json) {
            this.id = id;
            this.json = json;
        }

        public int getId() {
            return this.id;
        }

        public JsonObject getJson() {
            return this.json;
        }
    }
}

