/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.logging.Json;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.ClassPathTemplateLocator;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.gson.resolver.JsonElementResolver;
import org.trimou.handlebars.HelpersBuilder;

public class LogMessageReport {
    public static void main(String[] args) {
        if (args.length < 1) {
            LogMessageReport.printUsage();
            return;
        }
        File indexFile = new File(args[0]);
        File reportFile = null;
        if (args.length > 1) {
            reportFile = new File(args[1]);
        }
        LogMessageReport generator = new LogMessageReport();
        generator.createReportFile(indexFile, reportFile);
    }

    private static void printUsage() {
        System.out.println("Usage: java -cp weld-logging-tools-shaded.jar org.jboss.weld.logging.LogMessageReport DIFF_INDEX_FILE [REPORT_FILE]");
    }

    public void generate(File indexFile, Writer writer) {
        if (!indexFile.exists() || !indexFile.canRead()) {
            throw new IllegalArgumentException("Unable to read the index file: " + indexFile);
        }
        try {
            Mustache mustache;
            JsonObject json = Json.readJsonElementFromFile(indexFile).getAsJsonObject();
            MustacheEngine engine = ((MustacheEngineBuilder)MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().setProperty(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES, (Object)false).addTemplateLocator(ClassPathTemplateLocator.builder(1).setRootPath("templates").build()).addResolver(new MapResolver()).addResolver(new JsonElementResolver()).registerHelpers((Map)HelpersBuilder.all().build())).build();
            if (json.has("version")) {
                mustache = engine.getMustache("index.html");
            } else if (json.has("indexes")) {
                mustache = engine.getMustache("diff.html");
            } else {
                throw new IllegalStateException("Unsupported index file format: " + indexFile);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("json", json);
            data.put("indexFile", indexFile.toPath().toString());
            data.put("timestamp", new Date());
            mustache.render(writer, data);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse the index file: " + indexFile, e);
        }
    }

    public void createReportFile(File indexFile, File reportFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.initReportFile(indexFile, reportFile).toPath(), Charset.forName("UTF-8"), new OpenOption[0]);){
            this.generate(indexFile, writer);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create the report file: " + reportFile, e);
        }
    }

    File getDefaultReportFile(File indexFile) {
        String filename = indexFile.getName().substring(0, indexFile.getName().lastIndexOf(".json"));
        return new File(indexFile.getParentFile(), filename + ".html");
    }

    private File initReportFile(File indexFile, File reportFile) {
        if (reportFile == null) {
            reportFile = this.getDefaultReportFile(indexFile);
        }
        if (!reportFile.exists()) {
            try {
                reportFile.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create the report file: " + reportFile);
            }
        }
        if (!reportFile.canWrite()) {
            throw new IllegalStateException("Unable to write to the report file: " + reportFile);
        }
        return reportFile;
    }
}

