/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import org.apache.commons.lang3.math.NumberUtils;
import org.trimou.engine.resolver.AbstractResolver;

public abstract class IndexResolver
extends AbstractResolver {
    public IndexResolver(int priority) {
        super(priority);
    }

    protected boolean notAnIndex(String name) {
        return !this.isAnIndex(name);
    }

    protected boolean isAnIndex(String name) {
        return NumberUtils.isDigits(name);
    }

    protected Integer getIndexValue(String key, int maxSize) {
        Integer index = null;
        try {
            index = Integer.valueOf(key);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (index < 0 || index >= maxSize) {
            return null;
        }
        return index;
    }
}

