/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resource;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.engine.resource.ReleaseCallback;
import org.trimou.engine.resource.ReleaseCallbackContainer;

@Internal
public abstract class AbstractReleaseCallbackContainer
implements ReleaseCallbackContainer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReleaseCallbackContainer.class);
    private List<ReleaseCallback> releaseCallbacks = null;

    public void release() {
        if (this.releaseCallbacks != null) {
            for (ReleaseCallback callback : this.releaseCallbacks) {
                try {
                    callback.release();
                }
                catch (Exception e) {
                    logger.warn("Exception occured during release callback invocation:", e);
                }
            }
        }
    }

    @Override
    public void registerReleaseCallback(ReleaseCallback callback) {
        if (this.releaseCallbacks == null) {
            this.releaseCallbacks = new ArrayList<ReleaseCallback>(5);
        }
        this.releaseCallbacks.add(callback);
    }
}

