/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

class AsyncAppendable
implements Appendable {
    protected final Appendable parent;
    protected final StringBuilder buffer;
    protected volatile Future<AsyncAppendable> future;

    AsyncAppendable(Appendable parent) {
        this.parent = parent;
        this.buffer = new StringBuilder();
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.buffer.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.buffer.append(c);
        return this;
    }

    private void flush() {
        try {
            this.parent.append(this.future.get(60L, TimeUnit.SECONDS).collect(this));
            this.parent.append(this.buffer);
            if (this.parent instanceof AsyncAppendable) {
                ((AsyncAppendable)this.parent).flush();
            }
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_ASYNC_PROCESSING_ERROR, (Throwable)e);
        }
    }

    private CharSequence collect(AsyncAppendable latch) {
        if (this.parent.equals(latch) && this.future == null) {
            return this.buffer;
        }
        StringBuilder ret = null;
        if (this.parent instanceof AsyncAppendable && !this.parent.equals(latch)) {
            ret = new StringBuilder();
            ret.append(((AsyncAppendable)this.parent).collect(latch));
        }
        if (this.future != null) {
            try {
                if (ret == null) {
                    ret = new StringBuilder();
                }
                AsyncAppendable result = this.future.get(60L, TimeUnit.SECONDS);
                if (result.future != null) {
                    ret.append(result.collect(this));
                } else {
                    ret.append((CharSequence)result.buffer);
                    ret.append((CharSequence)this.buffer);
                }
                return ret;
            }
            catch (Exception e) {
                throw new MustacheException(MustacheProblem.RENDER_ASYNC_PROCESSING_ERROR, (Throwable)e);
            }
        }
        return ret != null ? ret.append((CharSequence)this.buffer) : this.buffer;
    }

    void setFuture(Future<AsyncAppendable> future) {
        this.future = future;
    }

    static void flushIfNeeded(Appendable appendable) {
        if (appendable instanceof AsyncAppendable) {
            ((AsyncAppendable)appendable).flush();
        }
    }
}

