/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;

@Internal
public class InvertedSectionSegment
extends AbstractSectionSegment {
    public InvertedSectionSegment(String text, Origin origin, List<Segment> segments) {
        super(text, origin, segments);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.INVERTED_SECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        ValueWrapper value = context.getValue(this.getText());
        try {
            if (value.isNull() || this.process(value.get())) {
                Appendable appendable2 = super.execute(appendable, context);
                return appendable2;
            }
            Appendable appendable3 = appendable;
            return appendable3;
        }
        finally {
            value.release();
        }
    }

    private boolean process(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }
}

