/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.i18n.LocaleAwareValueHelper;

public abstract class AbstractTimeFormatHelper<F, S>
extends LocaleAwareValueHelper {
    private static final Set<String> SUPPORTED_HASH_KEYS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("pattern")).add("style")).add("timeZone")).build();
    private final TimeZone defaultTimeZone = TimeZone.getDefault();

    @Override
    public void execute(Options options) {
        Locale locale = this.getLocale(options);
        TimeZone timeZone = this.getTimeZone(options);
        F value = this.getFormattableObject(options.getParameters().get(0), locale, timeZone, options.getTagInfo());
        Object styleOrPattern = this.getHashValue(options, "pattern");
        String text = styleOrPattern != null ? this.format(value, styleOrPattern.toString(), locale, timeZone) : ((styleOrPattern = this.getHashValue(options, "style")) != null ? this.format(value, this.parseStyle(styleOrPattern.toString(), options.getTagInfo()), locale, timeZone) : this.defaultFormat(value, locale, timeZone));
        options.append(text);
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of(SUPPORTED_HASH_KEYS);
    }

    protected abstract String defaultFormat(F var1, Locale var2, TimeZone var3);

    protected abstract String format(F var1, S var2, Locale var3, TimeZone var4);

    protected abstract String format(F var1, String var2, Locale var3, TimeZone var4);

    protected abstract S parseStyle(String var1, MustacheTagInfo var2);

    protected abstract F getFormattableObject(Object var1, Locale var2, TimeZone var3, MustacheTagInfo var4);

    protected TimeZone getTimeZone(Options options) {
        Object timeZoneObject = this.getHashValue(options, "timeZone");
        TimeZone timeZone = timeZoneObject != null ? (timeZoneObject instanceof TimeZone ? (TimeZone)timeZoneObject : TimeZone.getTimeZone(timeZoneObject.toString())) : this.defaultTimeZone;
        return timeZone;
    }

    protected MustacheException valueNotAFormattableObject(Object value, MustacheTagInfo tagInfo) {
        return new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Value is not a formattable object [value: %s, template: %s, line: %s]", value, tagInfo.getTemplateName(), tagInfo.getLine());
    }

    protected MustacheException unknownStyle(String style, MustacheTagInfo tagInfo) {
        return new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Unknown style defined %s [template: %s, line: %s]", style, tagInfo.getTemplateName(), tagInfo.getLine());
    }
}

