/*
 * JBoss, Home of Professional Open Source
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.logging;


/**
 *
 * @author Martin Kouba
 */
final class Strings {

    private Strings() {
    }

    static final String MESSAGE_LOGGER_CLASS_NAME = "org.jboss.logging.annotations.MessageLogger";
    static final String MESSAGE_CLASS_NAME = "org.jboss.logging.annotations.Message";
    static final String LOG_MESSAGE_CLASS_NAME = "org.jboss.logging.annotations.LogMessage";
    static final String SUPPRESS_WARNINGS_CLASS_NAME = "java.lang.SuppressWarnings";

    static final String VERSION = "version";
    static final String ARTIFACT = "artifact";
    static final String VERSIONS = "versions";
    static final String MESSAGES = "messages";
    static final String TOTAL = "total";
    static final String LOG_MESSAGE = "log";
    static final String MESSAGE = "msg";
    static final String METHOD_INFO = "method";
    static final String DESCRIPTION = "desc";
    static final String DIFFERENCES = "differences";
    static final String FILE_PATH = "filePath";
    static final String INDEXES = "indexes";
    static final String DETECT_COLLISIONS_ONLY = "detectCollisionsOnly";

    static final String SUPPRESSIONS = "suppressions";
    static final String SUPPRESS_WARNINGS_PREFIX = "weldlog:";

    static final String SIGNATURE = "sig";
    static final String RETURN_TYPE = "retType";
    static final String INTERFACE = "interface";

    static final String LEVEL = "level";
    static final String LOGGING_CLASS = "loggingClass";
    static final String ID = "id";
    static final String VALUE = "value";
    static final String FORMAT = "format";
    static final String PROJECT_CODE = "projectCode";

    static final String OPT_PROJECT_VERSION = "projectVersion";
    static final String OPT_ARTIFACT = "artifact";
    static final String OPT_OUTPUT_FILE = "outputFile";
    static final String UNKNOWN = "UNKNOWN";

}
