/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.lang.model.element.AnnotationValue;

final class Json {
    private Json() {
    }

    static JsonElement readJsonElementFromFile(File inputFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(inputFile.toPath(), Charset.forName("UTF-8"));){
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse((Reader)reader);
            return jsonElement;
        }
    }

    static void writeJsonElementToFile(JsonElement element, File outputFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile.toPath(), Charset.forName("UTF-8"), new OpenOption[0]);){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setHtmlSafe(true);
            Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
        }
    }

    static JsonElement wrapPrimitive(AnnotationValue annotationValue) {
        return Json.wrapPrimitive(annotationValue.getValue());
    }

    static JsonElement wrapPrimitive(Object value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        return new JsonPrimitive(value.toString());
    }
}

