/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.modeldumper;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

public class Main {
    private static List<String> REQUIRED_EXTENSIONS = Arrays.asList("org.wildfly.extension.datasources-agroal", "org.wildfly.extension.rts", "org.jboss.as.xts", "org.jboss.as.clustering.jgroups");

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("USAGE: java [-Dpath=dump-path-in-cli-format] -jar model-dumper.jar target-file");
            System.exit(1);
        }
        ModelControllerClient client = Main.connectDefault();
        ModelNode addr = new ModelNode();
        String address = System.getProperty("path");
        if (address != null) {
            String[] parts;
            for (String p : parts = address.split("/")) {
                String[] kv = p.split("=");
                if (kv.length != 2) {
                    throw new RuntimeException("invalid address " + address);
                }
                addr.add(kv[0], kv[1]);
            }
        }
        try {
            Main.validateRunningConfiguration(client);
            FileOutputStream out = new FileOutputStream(args[0]);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource-description");
            operation.get("recursive").set(true);
            operation.get("operations").set(true);
            operation.get("inherited").set(false);
            operation.get("address").set(addr);
            try {
                ModelNode result = Main.executeForResult(client, operation);
                result.get("possible-capabilities").set(Main.getPossibleCapabilites(client));
                result.get("version-info").set(Main.getVersionInfo(client));
                result.writeExternal(new DataOutputStream(out));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    private static void validateRunningConfiguration(ModelControllerClient client) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-children-names");
        operation.get("child-type").set("extension");
        operation.get("address").set(new ModelNode());
        ModelNode result = Main.executeForResult(client, operation);
        List present = result.asList().stream().map(ModelNode::asString).collect(Collectors.toList());
        for (String ext : REQUIRED_EXTENSIONS) {
            if (present.contains(ext)) continue;
            throw new RuntimeException(String.format("Running configuration is missing '%s' extension", ext));
        }
    }

    private static ModelNode getPossibleCapabilites(ModelControllerClient client) throws IOException {
        ModelNode addr = new ModelNode();
        addr.add("core-service", "capability-registry");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("possible-capabilities");
        operation.get("address").set(addr);
        try {
            return Main.executeForResult(client, operation);
        }
        catch (Exception e) {
            return new ModelNode().setEmptyList();
        }
    }

    private static ModelNode getVersionInfo(ModelControllerClient client) throws IOException {
        ModelNode addr = new ModelNode();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("attributes-only").set(true);
        operation.get("address").set(addr);
        try {
            return Main.executeForResult(client, operation);
        }
        catch (IOException e) {
            return new ModelNode().setEmptyObject();
        }
    }

    private static ModelControllerClient connectDefault() {
        ModelControllerClient client = null;
        try {
            client = ModelControllerClient.Factory.create("http-remoting", "localhost", 9990);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource-description");
            operation.get("recursive").set(false);
            operation.get("operations").set(true);
            operation.get("inherited").set(false);
            operation.get("address").set(new ModelNode());
            client.execute(operation);
            return client;
        }
        catch (Exception e) {
            IoUtils.safeClose(client);
            try {
                return ModelControllerClient.Factory.create("remote", "localhost", 9999);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
    }

    private static ModelControllerClient connect(String uri) {
        try {
            URI connect = new URI(uri);
            return ModelControllerClient.Factory.create(connect.getScheme(), connect.getHost(), connect.getPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ModelNode executeForResult(ModelControllerClient client, ModelNode operation) throws IOException {
        ModelNode result = client.execute(operation);
        Main.checkSuccessful(result);
        return result.get("result");
    }

    private static void checkSuccessful(ModelNode result) {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
    }
}

