/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;

public class ConfigFileHostEntryResolver
extends ModifiableFileWatcher
implements HostConfigEntryResolver {
    private final AtomicReference<HostConfigEntryResolver> delegateHolder = new AtomicReference<HostConfigEntryResolver>(HostConfigEntryResolver.EMPTY);

    public ConfigFileHostEntryResolver(Path file) {
        this(file, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public ConfigFileHostEntryResolver(Path file, LinkOption ... options) {
        super(file, options);
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String host, int port, SocketAddress localAddress, String username, String proxyJump, AttributeRepository context) throws IOException {
        try {
            HostConfigEntryResolver delegate = Objects.requireNonNull(this.resolveEffectiveResolver(host, port, username, proxyJump), "No delegate");
            HostConfigEntry entry = delegate.resolveEffectiveHost(host, port, localAddress, username, proxyJump, context);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveEffectiveHost({}@{}:{}/{}) => {}", username, host, port, proxyJump, entry);
            }
            return entry;
        }
        catch (Throwable e) {
            this.debug("resolveEffectiveHost({}@{}:{}/{}) failed ({}) to resolve: {}", username, host, port, proxyJump, e.getClass().getSimpleName(), e.getMessage(), e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    protected HostConfigEntryResolver resolveEffectiveResolver(String host, int port, String username, String proxyJump) throws IOException {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(HostConfigEntryResolver.EMPTY);
            Path path = this.getPath();
            if (this.exists()) {
                List<HostConfigEntry> entries = this.reloadHostConfigEntries(path, host, port, username, proxyJump);
                if (GenericUtils.size(entries) > 0) {
                    this.delegateHolder.set(HostConfigEntry.toHostConfigEntryResolver(entries));
                }
            } else {
                this.log.info("resolveEffectiveResolver({}@{}:{}/{}) no configuration file at {}", username, host, port, proxyJump, path);
            }
        }
        return this.delegateHolder.get();
    }

    protected List<HostConfigEntry> reloadHostConfigEntries(Path path, String host, int port, String username, String proxyJump) throws IOException {
        List<HostConfigEntry> entries = HostConfigEntry.readHostConfigEntries(path, new OpenOption[0]);
        this.log.info("resolveEffectiveResolver({}@{}:{}) loaded {} entries from {}", username, host, port, GenericUtils.size(entries), path);
        this.updateReloadAttributes();
        return entries;
    }
}

