/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.modeldumper;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.dmr.ModelNode;

public class Configuration {
    private final Path targetFile;
    private final Set<String> requiredExtensions;
    private String protocol;
    private String hostName;
    private int port;
    private ModelNode address;

    private Configuration(Path targetFile) {
        this.targetFile = targetFile;
        this.requiredExtensions = new LinkedHashSet<String>();
        this.protocol = null;
        this.hostName = "localhost";
        this.port = 9990;
        this.address = new ModelNode().setEmptyList();
    }

    public static Configuration of(Path targetFile) {
        return new Configuration(targetFile);
    }

    public ModelNode getAddress() {
        return this.address;
    }

    public Configuration setAddress(ModelNode address) {
        this.address = address;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Configuration setHostName(String hostName) {
        this.hostName = hostName == null ? "localhost" : hostName;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Configuration setPort(int port) {
        this.port = port;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Configuration setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Configuration addRequiredExtension(String name) {
        this.requiredExtensions.add(name);
        return this;
    }

    public Configuration addRequiredExtensions(String ... names) {
        Collections.addAll(this.requiredExtensions, names);
        return this;
    }

    public Configuration addRequiredExtensions(Collection<String> names) {
        this.requiredExtensions.addAll(names);
        return this;
    }

    public Set<String> getRequiredExtensions() {
        return new LinkedHashSet<String>(this.requiredExtensions);
    }

    public Path getTargetFile() {
        return this.targetFile;
    }
}

