/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.modeldumper;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.wildscribe.modeldumper.Configuration;
import org.jboss.wildscribe.modeldumper.ModelExporter;

public class Main {
    static final String REQUIRED_EXTENSIONS_PROPERTY = "org.jboss.wildscribe.moduledumper.required-extensions";
    static final List<String> REQUIRED_EXTENSIONS;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("USAGE: java [-Dpath=dump-path-in-cli-format] -jar model-dumper.jar target-file");
            System.exit(1);
        }
        Path target = Paths.get(args[0], new String[0]);
        Configuration configuration = Configuration.of(target).addRequiredExtensions(REQUIRED_EXTENSIONS);
        ModelNode addr = new ModelNode().setEmptyList();
        String address = System.getProperty("path");
        if (address != null) {
            String[] parts;
            for (String p : parts = address.split("/")) {
                String[] kv = p.split("=");
                if (kv.length != 2) {
                    throw new RuntimeException("invalid address " + address);
                }
                addr.add(kv[0], kv[1]);
            }
        }
        configuration.setAddress(addr);
        ModelExporter.toDmr(configuration);
    }

    static {
        String required = System.getProperty(REQUIRED_EXTENSIONS_PROPERTY);
        if (required != null && !required.isEmpty()) {
            ArrayList<String> requiredList = new ArrayList<String>();
            for (String s : required.split(",")) {
                requiredList.add(s.trim());
            }
            REQUIRED_EXTENSIONS = Collections.unmodifiableList(requiredList);
        } else {
            REQUIRED_EXTENSIONS = Collections.emptyList();
        }
    }
}

