/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.modeldumper;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.wildscribe.modeldumper.Configuration;

public class ModelExporter {
    private static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();

    public static Path toDmr(Configuration configuration) throws IOException {
        Path target = configuration.getTargetFile();
        try (ModelControllerClient client = ModelControllerClient.Factory.create(configuration.getProtocol(), configuration.getHostName(), configuration.getPort());
             OutputStream out = Files.newOutputStream(configuration.getTargetFile(), new OpenOption[0]);){
            ModelNode address = configuration.getAddress();
            Set<String> requiredExtensions = configuration.getRequiredExtensions();
            if (!requiredExtensions.isEmpty()) {
                Set<String> present = ModelExporter.getExtensions(client);
                for (String ext : present) {
                    requiredExtensions.remove(ext);
                }
            }
            if (!requiredExtensions.isEmpty()) {
                throw new RuntimeException(String.format("Running configuration is missing the following required extensions: %s", requiredExtensions));
            }
            ModelNode operation = Operations.createOperation("read-resource-description", address);
            operation.get("operations").set(true);
            operation.get("inherited").set(false);
            operation.get("recursive").set(true);
            try {
                ModelNode result = ModelExporter.executeForResult(client, operation);
                result.get("possible-capabilities").set(ModelExporter.getPossibleCapabilities(client));
                result.get("version-info").set(ModelExporter.getVersionInfo(client));
                result.writeExternal(new DataOutputStream(out));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return target;
    }

    private static Set<String> getExtensions(ModelControllerClient client) throws IOException {
        ModelNode operation = Operations.createOperation("read-children-names");
        operation.get("child-type").set("extension");
        ModelNode result = ModelExporter.executeForResult(client, operation);
        return result.asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
    }

    private static ModelNode executeForResult(ModelControllerClient client, ModelNode operation) throws IOException {
        ModelNode result = client.execute(operation);
        if (Operations.isSuccessfulOutcome(result)) {
            return Operations.readResult(result);
        }
        throw new RuntimeException(String.format("Failed to execute the operation %s:%n%s", operation, Operations.getFailureDescription(result)));
    }

    private static ModelNode getPossibleCapabilities(ModelControllerClient client) {
        ModelNode address = Operations.createAddress("core-service", "capability-registry");
        try {
            return ModelExporter.executeForResult(client, Operations.createReadAttributeOperation(address, "possible-capabilities"));
        }
        catch (Exception e) {
            return new ModelNode().setEmptyList();
        }
    }

    private static ModelNode getVersionInfo(ModelControllerClient client) {
        ModelNode operation = Operations.createReadResourceOperation(EMPTY_ADDRESS);
        operation.get("attributes-only").set(true);
        try {
            return ModelExporter.executeForResult(client, operation);
        }
        catch (IOException e) {
            return new ModelNode().setEmptyObject();
        }
    }
}

