/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.renderer;

import com.tinkerpop.blueprints.Graph;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.graph.renderer.GraphWriter;
import org.jboss.windup.graph.renderer.html.DagreD3JSHtmlWriter;
import org.jboss.windup.graph.renderer.html.SigmaJSHtmlWriter;
import org.jboss.windup.graph.renderer.html.VizJSHtmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphExporter {
    private static final Logger LOG = LoggerFactory.getLogger(GraphExporter.class);
    private final Graph graph;

    public GraphExporter(Graph graph) {
        this.graph = graph;
    }

    public void renderVizjs(File output, String vertexLabelProperty, String edgeLabel) throws FileNotFoundException, IOException {
        LOG.debug("Writing Vizjs graph to: " + output.getAbsolutePath());
        this.render(new VizJSHtmlWriter(this.graph, vertexLabelProperty, edgeLabel), output);
    }

    public void renderSigma(File output, String vertexLabelProperty, String edgeLabel) throws FileNotFoundException, IOException {
        LOG.debug("Writing Sigmajs graph to: " + output.getAbsolutePath());
        this.render(new SigmaJSHtmlWriter(this.graph, vertexLabelProperty, edgeLabel), output);
    }

    public void renderDagreD3(File output, String vertexLabelProperty, String edgeLabel) throws FileNotFoundException, IOException {
        LOG.debug("Writing DagreD3 graph to: " + output.getAbsolutePath());
        this.render(new DagreD3JSHtmlWriter(this.graph, vertexLabelProperty, edgeLabel), output);
    }

    public void render(GraphWriter writer, File output) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(output);
        writer.writeGraph(fos);
        IOUtils.closeQuietly((OutputStream)fos);
    }
}

