/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.renderer;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.gremlingroovy.GremlinGroovyModule;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import com.tinkerpop.frames.modules.typedgraph.TypedGraphModuleBuilder;
import java.io.File;
import org.jboss.windup.graph.renderer.GraphExporter;

public class SimpleGraphRenderer {
    private Graph graph;
    private FramedGraph<Graph> framed;
    private final GraphExporter exporter;
    private final String edgeLabel;

    public Graph getGraph() {
        return this.graph;
    }

    public FramedGraph<Graph> getFramed() {
        return this.framed;
    }

    public SimpleGraphRenderer(String edgeLabel) {
        this.edgeLabel = edgeLabel;
        this.graph = new TinkerGraph();
        this.exporter = new GraphExporter(this.graph);
        FramedGraphFactory factory = new FramedGraphFactory(new Module[]{new JavaHandlerModule(), new TypedGraphModuleBuilder().withClass(RenderableVertex.class).build(), new GremlinGroovyModule()});
        this.framed = factory.create(this.graph);
    }

    public void renderVizjs(File output) throws RuntimeException {
        try {
            this.exporter.renderVizjs(output, "label", this.edgeLabel);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception writing graph.", e);
        }
    }

    public void renderSigma(File output) throws RuntimeException {
        try {
            this.exporter.renderSigma(output, "label", this.edgeLabel);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception writing graph.", e);
        }
    }

    public void renderDagreD3(File output) throws RuntimeException {
        try {
            this.exporter.renderDagreD3(output, "label", this.edgeLabel);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception writing graph.", e);
        }
    }

    @TypeField(value="type")
    @TypeValue(value="RenderableVertex")
    public static interface RenderableVertex
    extends VertexFrame {
        @Property(value="label")
        public void setLabel(String var1);

        @Property(value="label")
        public String getLabel(String var1);

        @Adjacency(label="in", direction=Direction.IN)
        public Iterable<RenderableVertex> getIns();

        @Adjacency(label="in", direction=Direction.IN)
        public void addIn(RenderableVertex var1);

        @Adjacency(label="out", direction=Direction.OUT)
        public Iterable<RenderableVertex> getOuts();

        @Adjacency(label="out", direction=Direction.OUT)
        public void addOut(RenderableVertex var1);
    }
}

