/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.renderer.graphlib;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.renderer.GraphWriter;
import org.jboss.windup.graph.renderer.graphlib.GraphvizConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphlibWriter
implements GraphWriter {
    private static final Logger LOG = LoggerFactory.getLogger(GraphlibWriter.class);
    protected final Graph graph;
    protected final GraphvizConstants.GraphvizType type;
    protected final GraphvizConstants.GraphvizDirection direction;
    protected final String graphVariableName;
    protected final String vertexLabelProperty;
    protected final String edgeLabel;

    public GraphlibWriter(Graph graph) {
        this(graph, GraphvizConstants.GraphvizType.DIGRAPH, GraphvizConstants.GraphvizDirection.TOP_TO_BOTTOM, "g", "label", "label");
    }

    public GraphlibWriter(Graph graph, GraphvizConstants.GraphvizType type, GraphvizConstants.GraphvizDirection direction, String graphVariableName, String vertexLabelProperty, String edgeLabelProperty) {
        this.graph = graph;
        this.graphVariableName = graphVariableName;
        this.vertexLabelProperty = vertexLabelProperty;
        this.edgeLabel = edgeLabelProperty;
        this.type = type;
        this.direction = direction;
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        IOUtils.write((String)"function createGraph() {\n", (OutputStream)os);
        String tag = StringUtils.replaceEach((String)"\tvar %NAME = new dagreD3.%TYPE();\n", (String[])new String[]{"%NAME", "%TYPE"}, (String[])new String[]{this.graphVariableName, this.type.getName()});
        IOUtils.write((String)tag, (OutputStream)os);
        this.writeGraphNodes(os);
        this.writeGraphEdges(os);
        IOUtils.write((String)"\tvar renderer = new dagreD3.Renderer();\n", (OutputStream)os);
        IOUtils.write((String)StringUtils.replace((String)"\tvar layout = dagreD3.layout().nodeSep(20).rankDir(\"%DIRECTION\");\n", (String)"%DIRECTION", (String)this.direction.getDirection()), (OutputStream)os);
        IOUtils.write((String)StringUtils.replace((String)"\trenderer.run(%NAME, d3.select(\"svg g\"));\n", (String)"%NAME", (String)this.graphVariableName), (OutputStream)os);
        IOUtils.write((String)"}", (OutputStream)os);
    }

    private void writeGraphEdges(OutputStream os) throws IOException {
        int i = 0;
        for (Edge edge : this.graph.getEdges()) {
            String id = "" + i;
            String source = "" + edge.getVertex(Direction.OUT).getId().toString();
            String target = "" + edge.getVertex(Direction.IN).getId().toString();
            String label = "" + edge.getProperty(this.edgeLabel);
            if (this.edgeLabel != null) {
                label = this.edgeLabel;
            }
            this.writeGraphEdge(id, source, target, label, os);
            ++i;
        }
    }

    private void writeGraphEdge(String id, String source, String target, String label, OutputStream os) throws IOException {
        String tag = StringUtils.replaceEach((String)"\t%NAME.addEdge(%ID, %SOURCE, %TARGET, { label: \"%LABEL\" });\n", (String[])new String[]{"%NAME", "%ID", "%SOURCE", "%TARGET", "%LABEL"}, (String[])new String[]{this.graphVariableName, id, source, target, label});
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNode(String id, String label, OutputStream os) throws IOException {
        String tag = StringUtils.replaceEach((String)"\t%NAME.addNode(%ID, { label: \"%LABEL\", class: \"%CLZLIST\" });\n", (String[])new String[]{"%NAME", "%ID", "%LABEL", "%CLZLIST"}, (String[])new String[]{this.graphVariableName, id, label, ""});
        IOUtils.write((String)tag, (OutputStream)os);
    }

    private void writeGraphNodes(OutputStream os) throws IOException {
        for (Vertex vertex : this.graph.getVertices()) {
            String id = vertex.getId().toString();
            String label = (String)vertex.getProperty(this.vertexLabelProperty);
            this.writeGraphNode(id, label, os);
        }
    }
}

