/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.renderer.graphviz;

import com.tinkerpop.blueprints.Graph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jboss.windup.graph.renderer.dot.DotWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizWriter
extends DotWriter {
    private static final Logger LOG = LoggerFactory.getLogger(GraphvizWriter.class);
    private final CompiledScript vizJsCompiled;

    public GraphvizWriter(Graph graph) throws ScriptException, IOException {
        super(graph);
        throw new RuntimeException("Not yet implemented; this is unstable.  The javascript requires Int32Array, which isn't currently provided by Rhino.");
    }

    @Override
    public void writeGraph(OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        super.writeGraph(baos);
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("vizjs/viz.js")));
            builder.append("var result = new Viz(dotGraph);");
            String script = builder.toString();
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
            Compilable compilingEngine = (Compilable)((Object)engine);
            CompiledScript cscript = compilingEngine.compile(script);
            Bindings bindings = engine.getBindings(100);
            for (Map.Entry me : bindings.entrySet()) {
                System.out.printf("%s: %s\n", me.getKey(), String.valueOf(me.getValue()));
            }
            bindings.put("dotGraph", (Object)baos.toString());
            Object result = cscript.eval(bindings);
            LOG.info("Result:" + ReflectionToStringBuilder.toString((Object)result));
        }
        catch (Exception e) {
            throw new IOException("Exception generating graph.", e);
        }
    }
}

