/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.graph.model.TechnologyReferenceModel;

public class TechnologyReference {
    private String id;
    private VersionRange versionRange;

    public TechnologyReference(TechnologyReferenceModel model) {
        this(model.getTechnologyID(), model.getVersionRange());
    }

    public TechnologyReference(String id, String versionRange) {
        this.id = id;
        if (versionRange != null) {
            this.versionRange = Versions.parseVersionRange((String)versionRange);
        }
    }

    public TechnologyReference(String id, VersionRange versionRange) {
        this.id = id;
        this.versionRange = versionRange;
    }

    public TechnologyReference(String id) {
        this(id, (VersionRange)null);
    }

    public String getId() {
        return this.id;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TechnologyReference other = (TechnologyReference)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.versionRange == null ? other.versionRange != null : !this.versionRange.equals(other.versionRange));
    }
}

