/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.tags.TagService;
import org.jboss.windup.util.furnace.FileExtensionFilter;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

@Singleton
public class TagServiceHolder {
    private static final Logger log = Logger.getLogger(TagServiceHolder.class.getName());
    private TagService tagService = new TagService();
    @Inject
    private Furnace furnace;
    @Inject
    private FurnaceClasspathScanner scanner;

    @PostConstruct
    public void loadTagDefinitions() {
        Map addonToResourcesMap = this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter("tags.xml"));
        for (Map.Entry entry : addonToResourcesMap.entrySet()) {
            for (URL resource : (List)entry.getValue()) {
                log.info("Reading tags definitions from: " + resource.toString() + " from addon " + ((Addon)entry.getKey()).getId());
                try {
                    InputStream is = resource.openStream();
                    Throwable throwable = null;
                    try {
                        this.tagService.readTags(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    log.warning("Couldn't read tags definition: " + resource.toString() + " from addon " + ((Addon)entry.getKey()).getId());
                }
            }
        }
    }

    public TagService getTagService() {
        return this.tagService;
    }
}

