/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.loader.RuleProviderLoader;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RulesetMetadata;

public class DefaultRuleProviderLoader
implements RuleProviderLoader {
    @Inject
    private Furnace furnace;

    public List<RuleProvider> getProviders(RuleLoaderContext ruleLoaderContext) {
        return (List)this.furnace.getLockManager().performLocked(LockMode.READ, (Callable)new Callable<List<RuleProvider>>(){

            @Override
            public List<RuleProvider> call() throws Exception {
                ArrayList<RuleProvider> result = new ArrayList<RuleProvider>();
                Set addons = DefaultRuleProviderLoader.this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(AddonFilters.allStarted());
                for (Addon addon : addons) {
                    RulesetMetadata rulesetMetadata = null;
                    ExportedInstance metadataInstance = addon.getServiceRegistry().getExportedInstance(RulesetMetadata.class);
                    if (metadataInstance != null) {
                        rulesetMetadata = (RulesetMetadata)metadataInstance.get();
                    }
                    Set providerInstances = addon.getServiceRegistry().getExportedInstances(RuleProvider.class);
                    for (ExportedInstance instance : providerInstances) {
                        RuleProvider provider = (RuleProvider)instance.get();
                        if (provider.getMetadata() instanceof MetadataBuilder) {
                            ((MetadataBuilder)provider.getMetadata()).setRulesetMetadata(rulesetMetadata);
                        }
                        result.add(provider);
                    }
                }
                return result;
            }
        });
    }
}

