/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleKey;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.loader.RuleProviderLoader;
import org.jboss.windup.config.loader.RuleProviderSorter;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.util.ServiceLogger;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.util.Visitor;

public class RuleLoaderImpl
implements RuleLoader {
    public static Logger LOG = Logger.getLogger(RuleLoaderImpl.class.getName());
    @Inject
    private Imported<RuleProviderLoader> loaders;

    public RuleProviderRegistry loadConfiguration(RuleLoaderContext ruleLoaderContext) {
        return this.build(ruleLoaderContext);
    }

    private void printRulePhases(List<RuleProvider> allProviders) {
        ArrayList<RuleProvider> unsortedPhases = new ArrayList<RuleProvider>();
        for (RuleProvider provider : allProviders) {
            if (!(provider instanceof RulePhase)) continue;
            unsortedPhases.add(provider);
        }
        List<RuleProvider> sortedPhases = RuleProviderSorter.sort(unsortedPhases);
        StringBuilder rulePhaseSB = new StringBuilder();
        for (RuleProvider phase : sortedPhases) {
            Class<?> unproxiedClass = Proxies.unwrap((Object)phase).getClass();
            rulePhaseSB.append("\tPhase: ").append(unproxiedClass.getSimpleName()).append("\n");
        }
        LOG.info("Rule Phases: [\n" + rulePhaseSB.toString() + "]");
    }

    private void checkForDuplicateProviders(List<RuleProvider> providers) {
        HashMap<RuleProvider, RuleProvider> duplicates = new HashMap<RuleProvider, RuleProvider>(providers.size());
        for (RuleProvider provider : providers) {
            RuleProvider previousProvider = (RuleProvider)duplicates.get(provider);
            if (previousProvider != null) {
                String currentProviderOrigin = provider.getMetadata().getOrigin();
                String previousProviderOrigin = previousProvider.getMetadata().getOrigin();
                String typeMessage = previousProvider.getClass().equals(provider.getClass()) ? " (type: " + previousProviderOrigin + " and " + currentProviderOrigin + ")" : " (types: " + Proxies.unwrapProxyClassName(previousProvider.getClass()) + " at " + previousProviderOrigin + " and " + Proxies.unwrapProxyClassName(provider.getClass()) + " at " + currentProviderOrigin + ")";
                throw new WindupException("Found two providers with the same id: " + provider.getMetadata().getID() + typeMessage);
            }
            duplicates.put(provider, provider);
        }
    }

    private List<RuleProvider> getProviders(RuleLoaderContext ruleLoaderContext) {
        ArrayList<RuleProvider> unsortedProviders = new ArrayList<RuleProvider>();
        for (RuleProviderLoader loader : this.loaders) {
            unsortedProviders.addAll(loader.getProviders(ruleLoaderContext));
        }
        this.checkForDuplicateProviders(unsortedProviders);
        this.printRulePhases(unsortedProviders);
        List<RuleProvider> sortedProviders = RuleProviderSorter.sort(unsortedProviders);
        ServiceLogger.logLoadedServices((Logger)LOG, RuleProvider.class, sortedProviders);
        return Collections.unmodifiableList(sortedProviders);
    }

    private RuleProviderRegistry build(RuleLoaderContext ruleLoaderContext) {
        ArrayList rules;
        ArrayList<Rule> allRules = new ArrayList<Rule>(2000);
        List<RuleProvider> providers = this.getProviders(ruleLoaderContext);
        RuleProviderRegistry registry = new RuleProviderRegistry();
        registry.setProviders(providers);
        HashMap<RuleKey, Rule> overrideRules = new HashMap<RuleKey, Rule>();
        for (RuleProvider provider : providers) {
            if (!provider.getMetadata().isOverrideProvider()) continue;
            Configuration cfg = provider.getConfiguration(null);
            rules = cfg.getRules();
            for (Rule rule : rules) {
                overrideRules.put(new RuleKey(provider.getMetadata().getID(), rule.getId()), rule);
            }
        }
        for (RuleProvider provider : providers) {
            if (ruleLoaderContext.getRuleProviderFilter() != null) {
                boolean accepted = ruleLoaderContext.getRuleProviderFilter().accept((Object)provider);
                LOG.info((accepted ? "Accepted" : "Skipped") + ": [" + provider + "] by filter [" + ruleLoaderContext.getRuleProviderFilter() + "]");
                if (!accepted) continue;
            }
            if (provider.getMetadata().isOverrideProvider()) continue;
            Configuration cfg = provider.getConfiguration(null);
            rules = new ArrayList(cfg.getRules());
            ListIterator<Rule> ruleIterator = rules.listIterator();
            while (ruleIterator.hasNext()) {
                Rule rule = (Rule)ruleIterator.next();
                Rule overrideRule = (Rule)overrideRules.get(new RuleKey(provider.getMetadata().getID(), rule.getId()));
                if (overrideRule == null) continue;
                LOG.info("Replacing rule " + rule.getId() + " with a user override!");
                ruleIterator.set(overrideRule);
            }
            registry.setRules(provider, rules);
            int i = 0;
            for (final Rule rule : rules) {
                ++i;
                AbstractRuleProvider.enhanceRuleMetadata((RuleProvider)provider, (Rule)rule);
                if (rule instanceof RuleBuilder && StringUtils.isBlank((CharSequence)rule.getId())) {
                    ((RuleBuilder)rule).withId(this.generatedRuleID(provider, rule, i));
                }
                allRules.add(rule);
                if (!(rule instanceof ParameterizedRule)) continue;
                ParameterizedCallback callback = new ParameterizedCallback(){

                    public void call(Parameterized parameterized) {
                        Set names = parameterized.getRequiredParameterNames();
                        ParameterStore store = ((ParameterizedRule)rule).getParameterStore();
                        if (names != null) {
                            for (String name : names) {
                                Parameter parameter = store.get(name, (Parameter)new DefaultParameter(name));
                                if (!(parameter instanceof ConfigurableParameter)) continue;
                                ((ConfigurableParameter)parameter).bindsTo((Binding)Evaluation.property((String)name));
                            }
                        }
                        parameterized.setParameterStore(store);
                    }
                };
                ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
                new ConditionVisit((Condition)rule).accept((Visitor)conditionVisitor);
                ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
                new OperationVisit((Operation)rule).accept((Visitor)operationVisitor);
            }
        }
        ConfigurationBuilder result = ConfigurationBuilder.begin();
        for (Rule rule : allRules) {
            result.addRule(rule);
        }
        registry.setConfiguration((Configuration)result);
        return registry;
    }

    private String generatedRuleID(RuleProvider provider, Rule rule, int idx) {
        String provID = provider.getMetadata().getID();
        return provID + "_" + idx;
    }
}

