/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.loader.WindupRuleProviderLoader;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FileExtensionFilter;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;
import org.w3c.dom.Document;

public class XMLRuleProviderLoader
implements WindupRuleProviderLoader {
    public static final String CURRENT_WINDUP_SCRIPT = "CURRENT_WINDUP_SCRIPT";
    private static final String XML_RULES_EXTENSION = "windup.xml";
    @Inject
    private Furnace furnace;
    @Inject
    private FurnaceClasspathScanner scanner;

    public List<WindupRuleProvider> getProviders(GraphContext context) {
        ArrayList<WindupRuleProvider> providers = new ArrayList<WindupRuleProvider>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new WindupException("Failed to build xml parser due to: " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<Addon, List<URL>> addonFiles : this.getAddonWindupXmlFiles().entrySet()) {
            Addon addon = addonFiles.getKey();
            List<URL> urls = addonFiles.getValue();
            for (URL resource : urls) {
                try {
                    Document doc = dBuilder.parse(resource.toURI().toString());
                    ParserContext parser = new ParserContext(this.furnace);
                    parser.setAddonContainingInputXML(addon);
                    parser.processElement(doc.getDocumentElement());
                    providers.addAll(parser.getRuleProviders());
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        for (FileModel userRulesFileModel : cfg.getUserRulesPaths()) {
            for (URL resource : this.getWindupUserDirectoryXmlFiles(userRulesFileModel)) {
                try {
                    Document doc = dBuilder.parse(resource.toURI().toString());
                    ParserContext parser = new ParserContext(this.furnace);
                    String userRulesPath = userRulesFileModel.getFilePath();
                    parser.setXmlInputPath(Paths.get(userRulesPath, new String[0]));
                    parser.processElement(doc.getDocumentElement());
                    providers.addAll(parser.getRuleProviders());
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return providers;
    }

    private Map<Addon, List<URL>> getAddonWindupXmlFiles() {
        return this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_RULES_EXTENSION));
    }

    private Collection<URL> getWindupUserDirectoryXmlFiles(FileModel userRulesFileModel) {
        String userRulesPath;
        String string = userRulesPath = userRulesFileModel == null ? null : userRulesFileModel.getFilePath();
        if (userRulesPath == null) {
            return Collections.emptyList();
        }
        final ArrayList<URL> results = new ArrayList<URL>();
        try {
            Files.walkFileTree(Paths.get(userRulesPath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().toLowerCase().endsWith(".windup.xml")) {
                        results.add(file.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new WindupException("Failed to search userdir: \"" + userRulesPath + "\" for groovy rules due to: " + e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

