/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.metadata;

import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.versions.VersionException;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.parser.WindupXMLRulesetParsingException;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="sourceTechnology", namespace="http://windup.jboss.org/v1/xml")
public class MetadataSourceTechnologyHandler
implements ElementHandler<TechnologyReference> {
    private static String ID = "id";
    private static String VERSION_RANGE = "versionRange";
    public static final String METADATA_SOURCE_TECHNOLOGY_ELEMENT = "sourceTechnology";

    @Override
    public TechnologyReference processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String id = element.getAttribute(ID);
        String versionRange = element.getAttribute(VERSION_RANGE);
        if (StringUtils.isBlank((String)id)) {
            throw new WindupXMLRulesetParsingException("The 'sourceTechnology' element must have a non-empty '" + ID + "' attribute");
        }
        if (StringUtils.isBlank((String)versionRange)) {
            throw new WindupXMLRulesetParsingException("The 'sourceTechnology' element must have a non-empty '" + VERSION_RANGE + "' attribute");
        }
        try {
            Versions.parseVersionRange((String)versionRange);
        }
        catch (VersionException ex) {
            throw new WindupXMLRulesetParsingException("The '" + VERSION_RANGE + "' attribute with value \"" + versionRange + "\" in the element " + METADATA_SOURCE_TECHNOLOGY_ELEMENT + " is not a valid version", ex);
        }
        TechnologyReference reference = new TechnologyReference(id, versionRange);
        return reference;
    }
}

