/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.xml;

import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.phase.RulePhase;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="phase", namespace="http://windup.jboss.org/v1/xml")
public class PhaseHandler
implements ElementHandler<Void> {
    private Map<String, Class<? extends RulePhase>> cachedPhases;

    @Override
    public Void processElement(ParserContext context, Element element) throws ConfigurationException {
        String phaseStr = element.getTextContent().trim();
        Class<? extends RulePhase> phase = this.getPhases().get(this.classNameToKey(phaseStr));
        if (phase == null) {
            throw new IllegalArgumentException("Unrecognized phase \"" + phaseStr + "\"");
        }
        context.getBuilder().setPhase(phase);
        return null;
    }

    private String classNameToKey(String className) {
        return className.toUpperCase();
    }

    private Map<String, Class<? extends RulePhase>> getPhases() {
        if (this.cachedPhases == null) {
            this.cachedPhases = new HashMap<String, Class<? extends RulePhase>>();
            Furnace furnace = FurnaceHolder.getFurnace();
            for (RulePhase phase : furnace.getAddonRegistry(new AddonRepository[0]).getServices(RulePhase.class)) {
                Class<?> unwrappedClass = Proxies.unwrap((Object)phase).getClass();
                String simpleName = unwrappedClass.getSimpleName();
                this.cachedPhases.put(this.classNameToKey(simpleName), unwrappedClass);
            }
        }
        return this.cachedPhases;
    }
}

