/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.metadata.TechnologyMetadata;
import org.jboss.windup.config.metadata.TechnologyMetadataLoader;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;

public class XMLTechnologyMetadataLoader
implements TechnologyMetadataLoader {
    private static final Logger LOG = Logging.get(XMLTechnologyMetadataLoader.class);
    private static final String XML_EXTENSION = "\\.technology\\.metadata\\.xml";
    @Inject
    private Furnace furnace;
    private List<TechnologyMetadata> metadataList;

    private void load(GraphContext context) {
        this.metadataList = new ArrayList<TechnologyMetadata>();
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        for (FileModel userRulesFileModel : cfg.getUserRulesPaths()) {
            Visitor<File> visitor = new Visitor<File>(){

                public void visit(File file) {
                    XMLTechnologyMetadataLoader.this.loadMetadata(file);
                }
            };
            FileVisit.visit((File)userRulesFileModel.asFile(), (Predicate)new FileSuffixPredicate(XML_EXTENSION), (Visitor)visitor);
        }
    }

    private void loadMetadata(File file) {
        ParserContext parser = new ParserContext(this.furnace);
        parser.setXmlInputPath(file.toPath());
        parser.setXmlInputRootPath(file.getParentFile().toPath());
        TechnologyMetadata metadata = (TechnologyMetadata)parser.processDocument(file.toURI());
        this.metadataList.add(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadataIfNeeded(GraphContext context) {
        if (this.metadataList == null) {
            XMLTechnologyMetadataLoader xMLTechnologyMetadataLoader = this;
            synchronized (xMLTechnologyMetadataLoader) {
                if (this.metadataList == null) {
                    this.load(context);
                }
            }
        }
    }

    public TechnologyMetadata getMetadata(GraphContext context, TechnologyReference reference) {
        this.loadMetadataIfNeeded(context);
        for (TechnologyMetadata metadata : this.metadataList) {
            if (!metadata.handles(reference)) continue;
            return metadata;
        }
        return null;
    }
}

