/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.builder.RuleProviderBuilder;
import org.jboss.windup.config.loader.RuleProviderLoader;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FileExtensionFilter;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;
import org.w3c.dom.Document;

public class XMLRuleProviderLoader
implements RuleProviderLoader {
    private static final Logger LOG = Logging.get(XMLRuleProviderLoader.class);
    public static final String CURRENT_WINDUP_SCRIPT = "CURRENT_WINDUP_SCRIPT";
    private static final String XML_RULES_EXTENSION = "windup.xml";
    @Inject
    private Furnace furnace;
    @Inject
    private FurnaceClasspathScanner scanner;

    public List<RuleProvider> getProviders(GraphContext context) {
        ArrayList<RuleProvider> providers = new ArrayList<RuleProvider>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new WindupException("Failed to build xml parser due to: " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<Addon, List<URL>> addonFiles : this.getAddonWindupXmlFiles().entrySet()) {
            Addon addon = addonFiles.getKey();
            List<URL> urls = addonFiles.getValue();
            for (URL resource : urls) {
                try {
                    Document doc = dBuilder.parse(resource.toURI().toString());
                    ParserContext parser = new ParserContext(this.furnace);
                    parser.setAddonContainingInputXML(addon);
                    parser.processElement(doc.getDocumentElement());
                    List<AbstractRuleProvider> parsedProviders = parser.getRuleProviders();
                    this.setOrigin(parsedProviders, resource);
                    providers.addAll(parsedProviders);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        for (FileModel userRulesFileModel : cfg.getUserRulesPaths()) {
            Collection<URL> userXmlRulesetFiles = this.getWindupUserDirectoryXmlFiles(userRulesFileModel);
            StringBuilder sb = new StringBuilder("\nFound " + userXmlRulesetFiles.size() + " user XML rules in: " + userRulesFileModel.getFilePath());
            for (URL resource : userXmlRulesetFiles) {
                sb.append("\n\t" + resource.toString());
            }
            LOG.info(sb.toString());
            for (URL resource : userXmlRulesetFiles) {
                try {
                    Document doc = dBuilder.parse(resource.toURI().toString());
                    ParserContext parser = new ParserContext(this.furnace);
                    String userRulesPath = userRulesFileModel.getFilePath();
                    parser.setXmlInputPath(Paths.get(resource.toURI()));
                    parser.setXmlInputRootPath(Paths.get(userRulesPath, new String[0]));
                    parser.processElement(doc.getDocumentElement());
                    List<AbstractRuleProvider> parsedProviders = parser.getRuleProviders();
                    this.setOrigin(parsedProviders, resource);
                    providers.addAll(parsedProviders);
                }
                catch (Exception e) {
                    userRulesFileModel.setParseError("Failed to parse XML configuration: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return providers;
    }

    private void setOrigin(List<AbstractRuleProvider> providers, URL resource) {
        for (AbstractRuleProvider provider : providers) {
            if (!(provider instanceof RuleProviderBuilder)) continue;
            ((RuleProviderBuilder)provider).setOrigin(resource.toExternalForm());
        }
    }

    private Map<Addon, List<URL>> getAddonWindupXmlFiles() {
        return this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_RULES_EXTENSION));
    }

    private Collection<URL> getWindupUserDirectoryXmlFiles(FileModel userRulesFileModel) {
        String userRulesDirectory;
        String string = userRulesDirectory = userRulesFileModel == null ? null : userRulesFileModel.getFilePath();
        if (userRulesDirectory == null) {
            return Collections.emptyList();
        }
        Path userRulesPath = Paths.get(userRulesDirectory, new String[0]);
        if (!Files.isDirectory(userRulesPath, new LinkOption[0])) {
            LOG.warning("Not scanning: " + userRulesPath.normalize().toString() + " for rules as the directory could not be found!");
            return Collections.emptyList();
        }
        if (!Files.isDirectory(userRulesPath, new LinkOption[0])) {
            LOG.warning("Not scanning: " + userRulesPath.normalize().toString() + " for rules as the directory could not be read!");
            return Collections.emptyList();
        }
        final ArrayList<URL> results = new ArrayList<URL>();
        try {
            Files.walkFileTree(userRulesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().toLowerCase().endsWith(".windup.xml")) {
                        results.add(file.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new WindupException("Failed to search userdir: \"" + userRulesDirectory + "\" for groovy rules due to: " + e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

