/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformer;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformerLoader;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;

public class XMLTechnologyReferenceTransformerLoader
implements TechnologyReferenceTransformerLoader {
    private static final String XML_EXTENSION = ".windup.technologytransformer.xml";
    @Inject
    private Furnace furnace;

    public Collection<TechnologyReferenceTransformer> loadTransformers(RuleLoaderContext ruleLoaderContext) {
        final ArrayList<TechnologyReferenceTransformer> transformers = new ArrayList<TechnologyReferenceTransformer>();
        for (Path userRulesPath : ruleLoaderContext.getRulePaths()) {
            Visitor<File> visitor = new Visitor<File>(){

                public void visit(File file) {
                    transformers.addAll(XMLTechnologyReferenceTransformerLoader.this.loadTransformers(file));
                }
            };
            FileVisit.visit((File)userRulesPath.toFile(), (Predicate)new FileSuffixPredicate(XML_EXTENSION), (Visitor)visitor);
        }
        return transformers;
    }

    private List<TechnologyReferenceTransformer> loadTransformers(File file) {
        ParserContext parser = new ParserContext(this.furnace);
        parser.setXmlInputPath(file.toPath());
        parser.setXmlInputRootPath(file.getParentFile().toPath());
        return (List)parser.processDocument(file.toURI());
    }
}

