/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.builder.RuleProviderBuilder;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.loader.RuleProviderLoader;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FileExtensionFilter;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;
import org.w3c.dom.Document;

public class XMLRuleProviderLoader
implements RuleProviderLoader {
    private static final Logger LOG = Logging.get(XMLRuleProviderLoader.class);
    private static final String XML_RULES_WINDUP_EXTENSION = "windup.xml";
    private static final String XML_RULES_RHAMT_EXTENSION = "rhamt.xml";
    @Inject
    private Furnace furnace;
    @Inject
    private FurnaceClasspathScanner scanner;

    public boolean isFileBased() {
        return true;
    }

    public List<RuleProvider> getProviders(RuleLoaderContext ruleLoaderContext) {
        List<AbstractRuleProvider> parsedProviders;
        ParserContext parser;
        Document doc;
        DocumentBuilder dBuilder;
        ArrayList<RuleProvider> providers = new ArrayList<RuleProvider>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new WindupException("Failed to build xml parser due to: " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<Addon, List<URL>> addonFiles : this.getAddonWindupXmlFiles().entrySet()) {
            Addon addon = addonFiles.getKey();
            List<URL> urls = addonFiles.getValue();
            for (URL resource : urls) {
                try {
                    doc = dBuilder.parse(resource.toURI().toString());
                    parser = new ParserContext(this.furnace, ruleLoaderContext);
                    parser.setAddonContainingInputXML(addon);
                    parser.processElement(doc.getDocumentElement());
                    parsedProviders = parser.getRuleProviders();
                    this.setOrigin(parsedProviders, resource);
                    providers.addAll(parsedProviders);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        for (Path userRulesPath : ruleLoaderContext.getRulePaths()) {
            Collection<URL> userXmlRulesetFiles = this.getWindupUserDirectoryXmlFiles(userRulesPath);
            StringBuilder sb = new StringBuilder(System.lineSeparator() + "Found " + userXmlRulesetFiles.size() + " user XML rules in: " + userRulesPath);
            for (URL resource : userXmlRulesetFiles) {
                sb.append(System.lineSeparator()).append("\t").append(resource.toString());
            }
            LOG.info(sb.toString());
            for (URL resource : userXmlRulesetFiles) {
                try {
                    doc = dBuilder.parse(resource.toURI().toString());
                    parser = new ParserContext(this.furnace, ruleLoaderContext);
                    parser.setXmlInputPath(Paths.get(resource.toURI()));
                    parser.setXmlInputRootPath(userRulesPath);
                    parser.processElement(doc.getDocumentElement());
                    parsedProviders = parser.getRuleProviders();
                    this.setOrigin(parsedProviders, resource);
                    providers.addAll(parsedProviders);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return providers;
    }

    private void setOrigin(List<AbstractRuleProvider> providers, URL resource) {
        for (AbstractRuleProvider provider : providers) {
            if (!(provider instanceof RuleProviderBuilder)) continue;
            ((RuleProviderBuilder)provider).setOrigin(resource.toExternalForm());
        }
    }

    private Map<Addon, List<URL>> getAddonWindupXmlFiles() {
        Map addon = this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_RULES_WINDUP_EXTENSION));
        addon.putAll(this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_RULES_RHAMT_EXTENSION)));
        return addon;
    }

    private Collection<URL> getWindupUserDirectoryXmlFiles(Path userRulesPath) {
        if (userRulesPath == null) {
            return Collections.emptyList();
        }
        try {
            if (Files.isRegularFile(userRulesPath, new LinkOption[0]) && this.pathMatchesNamePattern(userRulesPath)) {
                return Collections.singletonList(userRulesPath.toUri().toURL());
            }
            if (!Files.isDirectory(userRulesPath, new LinkOption[0])) {
                LOG.warning("Not scanning: " + userRulesPath.normalize().toString() + " for rules as the directory could not be read!");
                return Collections.emptyList();
            }
            final ArrayList<URL> results = new ArrayList<URL>();
            Files.walkFileTree(userRulesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (XMLRuleProviderLoader.this.pathMatchesNamePattern(file)) {
                        results.add(file.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return results;
        }
        catch (IOException e) {
            throw new WindupException("Failed to search userdir: \"" + userRulesPath + "\" for XML rules due to: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean pathMatchesNamePattern(Path file) {
        return file.getFileName().toString().toLowerCase().endsWith(".windup.xml") || file.getFileName().toString().toLowerCase().endsWith(".rhamt.xml");
    }
}

