/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.config.metadata.TechnologyReference;

public class TargetOption
extends AbstractConfigurationOption {
    public static final String NAME = "target";
    @Inject
    private RuleProviderRegistryCache cache;

    public Collection<?> getAvailableValues() {
        HashSet<String> targetOptions = new HashSet<String>();
        for (RuleProvider provider : this.cache.getRuleProviderRegistry().getProviders()) {
            for (TechnologyReference technologyReference : provider.getMetadata().getTargetTechnologies()) {
                targetOptions.add(technologyReference.getId());
            }
        }
        return targetOptions;
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Target server or framework";
    }

    public String getDescription() {
        return "The target server or framework to migrate to. This could include multiple items (eg, \"JBoss EAP 6\" and \"EJB 3\")";
    }

    public InputType getUIType() {
        return InputType.SELECT_MANY;
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean isRequired() {
        return false;
    }

    public ValidationResult validate(Object value) {
        return ValidationResult.SUCCESS;
    }
}

