/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.AbstractPathConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class InputPathOption
extends AbstractPathConfigurationOption {
    private static Logger LOG = Logger.getLogger(InputPathOption.class.getCanonicalName());
    public static final String NAME = "input";
    private static final long SIZE_WARNING_TRESHOLD_MB = 10L;

    public InputPathOption() {
        super(true);
    }

    public Class<?> getType() {
        return Path.class;
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Input paths";
    }

    public String getDescription() {
        return "Input file or directory (a directory is required for source mode)";
    }

    public ValidationResult validate(Object filesObject) {
        ValidationResult result = super.validate(filesObject);
        if (!result.isSuccess()) {
            return result;
        }
        LinkedList<Path> largeApps = new LinkedList<Path>();
        for (Path path : (Iterable)filesObject) {
            ValidationResult resultFile = super.validate((Object)path);
            if (!resultFile.isSuccess()) {
                return resultFile;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return new ValidationResult(ValidationResult.Level.ERROR, "Input path not found: " + path);
            }
            if (Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                long fileSize = Files.size(path);
                if (fileSize <= 0xA00000L) continue;
                largeApps.add(path);
            }
            catch (IOException e) {
                LOG.warning("Could not determine file size for: " + path);
            }
        }
        if (!largeApps.isEmpty()) {
            return new ValidationResult(ValidationResult.Level.PROMPT_TO_CONTINUE, "These input applications or directories are large:\n\t" + StringUtils.join(largeApps, (String)"\n\t") + "\n" + " Processing may take a very long time." + " Please consult the Windup User Guide for performance tips." + " Would you like to continue?", true);
        }
        return ValidationResult.SUCCESS;
    }

    public InputType getUIType() {
        return InputType.MANY;
    }

    public boolean isRequired() {
        return true;
    }

    public int getPriority() {
        return 10000;
    }
}

