/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.rulefilters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.TechnologyReference;

public class SourceAndTargetPredicate
implements Predicate<RuleProvider> {
    private final Map<String, VersionRange> sources;
    private final Map<String, VersionRange> targets;

    public SourceAndTargetPredicate(Collection<String> sources, Collection<String> targets) {
        this.sources = this.initSet(sources);
        this.targets = this.initSet(targets);
    }

    public boolean accept(RuleProvider type) {
        Set providerSources = type.getMetadata().getSourceTechnologies();
        Set providerTargets = type.getMetadata().getTargetTechnologies();
        return this.techMatches(this.sources, providerSources) && this.techMatches(this.targets, providerTargets);
    }

    private boolean techMatches(Map<String, VersionRange> techs, Set<TechnologyReference> technologyReferences) {
        if (techs.isEmpty() || technologyReferences.isEmpty()) {
            return true;
        }
        for (TechnologyReference technologyReference : technologyReferences) {
            if (!techs.containsKey(technologyReference.getId())) continue;
            VersionRange expectedRange = techs.get(technologyReference.getId());
            return technologyReference.versionRangesOverlap(expectedRange);
        }
        return false;
    }

    private Map<String, VersionRange> initSet(Collection<String> values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        HashMap<String, VersionRange> result = new HashMap<String, VersionRange>();
        for (String value : values) {
            TechnologyReference reference = TechnologyReference.parseFromIDAndVersion((String)value);
            result.put(reference.getId(), reference.getVersionRange());
            result.put(value, null);
        }
        return result;
    }

    public String toString() {
        return "SourceAndTargetPredicate{sources=" + this.sources + ", targets=" + this.targets + '}';
    }
}

