/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.HandlerId;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.util.Annotations;
import org.joox.JOOX;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderPerform;
import org.ocpsoft.rewrite.config.ConfigurationRuleParameterWhere;
import org.w3c.dom.Element;

public class ParserContext {
    private final Map<HandlerId, ElementHandler<?>> handlers = new HashMap();
    private final ConfigurationBuilder builder;
    private ConfigurationRuleBuilderPerform rule;
    private ConfigurationRuleParameterWhere where;

    public ParserContext(ConfigurationBuilder builder) {
        List loadedHandlers = Iterators.asList((Iterable)ServiceLoader.load(ElementHandler.class));
        for (ElementHandler handler : loadedHandlers) {
            NamespaceElementHandler annotation = (NamespaceElementHandler)Annotations.getAnnotation(handler.getClass(), NamespaceElementHandler.class);
            if (annotation == null) continue;
            this.handlers.put(new HandlerId(annotation.namespace(), annotation.elementName()), handler);
        }
        this.builder = builder;
    }

    public <T> T processElement(Element element) throws ConfigurationException {
        String tagName;
        String namespace = JOOX.$((Element)element).namespaceURI();
        ElementHandler<?> handler = this.handlers.get(new HandlerId(namespace, tagName = JOOX.$((Element)element).tag()));
        if (handler != null) {
            Object o = handler.processElement(this, element);
            return (T)o;
        }
        throw new ConfigurationException("No Handler registered for element named [" + tagName + "] in namespace: [" + namespace + "]");
    }

    public ConfigurationBuilder getBuilder() {
        return this.builder;
    }

    public void setRuleBuilder(ConfigurationRuleBuilderPerform perform) {
        this.rule = perform;
    }

    public ConfigurationRuleBuilderPerform getRule() {
        return this.rule;
    }

    public void setWhereBuilder(ConfigurationRuleParameterWhere where) {
        this.where = where;
    }

    public ConfigurationRuleParameterWhere getWhere() {
        return this.where;
    }
}

