/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.EventEdge;
import com.tinkerpop.blueprints.util.wrappers.event.EventVertex;
import com.tinkerpop.frames.EdgeFrame;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.AbstractModule;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.TypeResolver;
import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeRegistry;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.graph.GraphModelScanner;
import org.jboss.windup.graph.model.WindupFrame;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

public class GraphTypeManager
implements TypeResolver,
FrameInitializer {
    private static final Logger LOG = Logger.getLogger(GraphTypeManager.class.getName());
    private Map<String, Class<? extends WindupFrame<?>>> registeredTypes;
    private TypeRegistry typeRegistry;

    private void initRegistry() {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)GraphTypeManager.class.getClassLoader());
        FurnaceClasspathScanner furnaceClasspathScanner = (FurnaceClasspathScanner)furnace.getAddonRegistry(new AddonRepository[0]).getServices(FurnaceClasspathScanner.class).get();
        this.registeredTypes = new HashMap();
        this.typeRegistry = new TypeRegistry();
        GraphModelScanner.loadFrames(furnaceClasspathScanner).forEach(this::addTypeToRegistry);
    }

    public Set<Class<? extends WindupFrame<?>>> getRegisteredTypes() {
        return Collections.unmodifiableSet(new HashSet(this.getRegisteredTypeMap().values()));
    }

    private synchronized Map<String, Class<? extends WindupFrame<?>>> getRegisteredTypeMap() {
        if (this.registeredTypes == null) {
            this.initRegistry();
        }
        return this.registeredTypes;
    }

    private synchronized TypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.initRegistry();
        }
        return this.typeRegistry;
    }

    private void addTypeToRegistry(Class<? extends WindupFrame<?>> frameType) {
        LOG.info(" Adding type to registry: " + frameType.getName());
        TypeValue typeValueAnnotation = frameType.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            String msg = String.format("@%s is missing on type %s", TypeValue.class.getSimpleName(), frameType.getName());
            LOG.warning(msg);
            return;
        }
        if (this.getRegisteredTypeMap().containsKey(typeValueAnnotation.value())) {
            throw new IllegalArgumentException("Type value for model '" + frameType.getCanonicalName() + "' is already registered with model " + this.getRegisteredTypeMap().get(typeValueAnnotation.value()).getName());
        }
        this.getRegisteredTypeMap().put(typeValueAnnotation.value(), frameType);
        this.getTypeRegistry().add(frameType);
    }

    public void removeTypeFromElement(Class<? extends WindupFrame<?>> kind, Element element) {
        Class typeHoldingTypeField = this.getTypeRegistry().getTypeHoldingTypeField(kind);
        if (typeHoldingTypeField == null) {
            return;
        }
        String typeFieldName = typeHoldingTypeField.getAnnotation(TypeField.class).value();
        TypeValue typeValueAnnotation = kind.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return;
        }
        String typeValue = typeValueAnnotation.value();
        AbstractElement abstractElement = GraphTypeManager.asTitanElement(element);
        ArrayList<String> newTypes = new ArrayList<String>();
        for (String existingType : (Iterable)abstractElement.getProperty(typeFieldName)) {
            if (existingType.toString().equals(typeValue)) continue;
            newTypes.add(typeValue);
        }
        abstractElement.removeProperty(typeFieldName);
        for (String newType : newTypes) {
            this.addProperty(abstractElement, typeFieldName, newType);
        }
        this.addSuperclassType(kind, element);
    }

    private void addProperty(AbstractElement abstractElement, String propertyName, String propertyValue) {
        if (abstractElement instanceof StandardVertex) {
            ((StandardVertex)abstractElement).addProperty(propertyName, (Object)propertyValue);
        } else if (abstractElement instanceof StandardEdge) {
            this.addTokenProperty(abstractElement, propertyName, propertyValue);
        } else {
            List existingList = (List)abstractElement.getProperty(propertyName);
            if (existingList == null) {
                abstractElement.setProperty(propertyName, Collections.singletonList(propertyValue));
            } else {
                ArrayList<String> newList = new ArrayList<String>(existingList);
                newList.add(propertyValue);
                abstractElement.setProperty(propertyName, newList);
            }
        }
    }

    private void addTokenProperty(AbstractElement el, String propertyName, String propertyValue) {
        Object val = el.getProperty(propertyName);
        if (val == null) {
            el.setProperty(propertyName, (Object)propertyValue);
        } else {
            el.setProperty(propertyName, (Object)(val + "|" + propertyValue));
        }
    }

    public static String getTypeIdentifier(Class<? extends VertexFrame> modelInterface) {
        TypeValue typeValueAnnotation = modelInterface.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return null;
        }
        return typeValueAnnotation.value();
    }

    public void addTypeToElement(String typeString, Element element) {
        Class<? extends WindupFrame<?>> kind = this.getRegisteredTypeMap().get(typeString);
        if (kind == null) {
            throw new IllegalArgumentException("Unrecognized type: " + typeString);
        }
        this.addTypeToElement(kind, element);
    }

    public void addTypeToElement(Class<? extends WindupFrame<?>> kind, Element element) {
        Class typeHoldingTypeField = this.getTypeRegistry().getTypeHoldingTypeField(kind);
        if (typeHoldingTypeField == null) {
            return;
        }
        TypeValue typeValueAnnotation = kind.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return;
        }
        String typeFieldName = typeHoldingTypeField.getAnnotation(TypeField.class).value();
        String typeValue = typeValueAnnotation.value();
        AbstractElement abstractElement = GraphTypeManager.asTitanElement(element);
        Object typeProp = abstractElement.getProperty(typeFieldName);
        if (typeProp != null) {
            if (!(typeProp instanceof Iterable)) {
                throw new RuntimeException("Discriminators property is not Iterable, but " + typeProp.getClass() + ": " + typeProp);
            }
            for (String existingType : (Iterable)typeProp) {
                if (!existingType.equals(typeValue)) continue;
                return;
            }
        }
        this.addProperty(abstractElement, typeFieldName, typeValue);
        this.addSuperclassType(kind, element);
    }

    private void addSuperclassType(Class<? extends WindupFrame<?>> kind, Element element) {
        for (Class<?> superInterface : kind.getInterfaces()) {
            if (!WindupFrame.class.isAssignableFrom(superInterface)) continue;
            this.addTypeToElement(superInterface, element);
        }
    }

    public Class<?>[] resolveTypes(Edge e, Class<?> defaultType) {
        return this.resolve((Element)e, defaultType);
    }

    public Class<?>[] resolveTypes(Vertex v, Class<?> defaultType) {
        return this.resolve((Element)v, defaultType);
    }

    public static boolean hasType(Class<? extends WindupVertexFrame> type, WindupVertexFrame frame) {
        return GraphTypeManager.hasType(type, frame.asVertex());
    }

    public static boolean hasType(Class<? extends WindupVertexFrame> type, Vertex v) {
        TypeValue typeValueAnnotation = type.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            throw new IllegalArgumentException("Class " + type.getCanonicalName() + " lacks a @TypeValue annotation");
        }
        AbstractElement abstractElement = GraphTypeManager.asTitanElement((Element)v);
        Iterable vertexTypes = (Iterable)abstractElement.getProperty("w:winduptype");
        for (String typeValue : vertexTypes) {
            if (!typeValue.equals(typeValueAnnotation.value())) continue;
            return true;
        }
        return false;
    }

    public static AbstractElement asTitanElement(Element e) {
        if (e instanceof StandardVertex) {
            return (StandardVertex)e;
        }
        if (e instanceof EventVertex) {
            return (AbstractElement)((EventVertex)e).getBaseVertex();
        }
        if (e instanceof StandardEdge) {
            return (StandardEdge)e;
        }
        if (e instanceof EventEdge) {
            return (AbstractElement)((EventEdge)e).getBaseEdge();
        }
        throw new IllegalArgumentException("Unrecognized element type: " + e.getClass());
    }

    private Class<?>[] resolve(Element e, Class<?> defaultType) {
        Class typeHoldingTypeField = this.getTypeRegistry().getTypeHoldingTypeField(defaultType);
        if (typeHoldingTypeField == null) {
            return new Class[]{defaultType, VertexFrame.class};
        }
        String propName = typeHoldingTypeField.getAnnotation(TypeField.class).value();
        AbstractElement abstractElement = GraphTypeManager.asTitanElement(e);
        Object typeValue = abstractElement.getProperty(propName);
        if (typeValue == null) {
            return new Class[]{defaultType, VertexFrame.class};
        }
        List<String> valuesAll = null;
        if (abstractElement instanceof StandardVertex) {
            if (!Iterable.class.isAssignableFrom(typeValue.getClass())) {
                throw new WindupException(String.format("Expected Iterable stored in vertex's %s, was %s: %s", propName, typeValue.getClass().getName(), typeValue.toString()));
            }
            valuesAll = (List<String>)typeValue;
        } else if (abstractElement instanceof TitanEdge) {
            if (!String.class.isAssignableFrom(typeValue.getClass())) {
                throw new WindupException(String.format("Expected String with tokens stored in edge's %s, was %s: %s", propName, typeValue.getClass().getName(), typeValue.toString()));
            }
            valuesAll = Arrays.asList(((String)typeValue).split("|"));
        } else {
            throw new WindupException(String.format("Unknown element type: %s", abstractElement.getClass().getName()));
        }
        ArrayList<Class<VertexFrame>> resultClasses = new ArrayList<Class<VertexFrame>>();
        for (String value : valuesAll) {
            Class type = this.getTypeRegistry().getType(typeHoldingTypeField, value);
            if (type == null) continue;
            ListIterator previouslyAddedIterator = resultClasses.listIterator();
            boolean shouldAdd = true;
            while (previouslyAddedIterator.hasNext()) {
                Class previouslyAdded = (Class)previouslyAddedIterator.next();
                if (previouslyAdded.isAssignableFrom(type)) {
                    previouslyAddedIterator.remove();
                    continue;
                }
                if (!type.isAssignableFrom(previouslyAdded)) continue;
                shouldAdd = false;
            }
            if (!shouldAdd) continue;
            resultClasses.add(type);
        }
        if (!resultClasses.isEmpty()) {
            resultClasses.add(VertexFrame.class);
            return resultClasses.toArray(new Class[resultClasses.size()]);
        }
        return new Class[]{defaultType, VertexFrame.class};
    }

    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        if (VertexFrame.class.isAssignableFrom(kind) || EdgeFrame.class.isAssignableFrom(kind)) {
            this.addTypeToElement(kind, element);
        }
    }

    public Module build() {
        return new AbstractModule(){

            public void doConfigure(FramedGraphConfiguration config) {
                config.addTypeResolver((TypeResolver)GraphTypeManager.this);
                config.addFrameInitializer((FrameInitializer)GraphTypeManager.this);
            }
        };
    }
}

