/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class XmlFileXPathTransformer {
    private static final String WINDUP_MATCHES_FUNCTION_PREFIX = "windup:matches(";

    public static String transformXPath(String originalXPath) {
        ArrayList<StringBuilder> compiledXPaths = new ArrayList<StringBuilder>(1);
        int frameIdx = -1;
        boolean inQuote = false;
        int conditionLevel = 0;
        char startQuoteChar = '\u0000';
        StringBuilder currentXPath = new StringBuilder();
        compiledXPaths.add(currentXPath);
        for (int i = 0; i < originalXPath.length(); ++i) {
            char curChar = originalXPath.charAt(i);
            if (!inQuote && curChar == '[') {
                ++conditionLevel;
                currentXPath.append("[windup:startFrame(").append(++frameIdx).append(") and windup:evaluate(").append(frameIdx).append(", ");
                continue;
            }
            if (!inQuote && curChar == ']') {
                --conditionLevel;
                currentXPath.append(")]");
                continue;
            }
            if (!inQuote && conditionLevel == 0 && curChar == '|') {
                currentXPath = new StringBuilder();
                compiledXPaths.add(currentXPath);
                continue;
            }
            if (inQuote && curChar == startQuoteChar) {
                inQuote = false;
                startQuoteChar = '\u0000';
            } else if (curChar == '\"' || curChar == '\'') {
                inQuote = true;
                startQuoteChar = curChar;
            }
            if (!inQuote && originalXPath.startsWith(WINDUP_MATCHES_FUNCTION_PREFIX, i)) {
                i += WINDUP_MATCHES_FUNCTION_PREFIX.length() - 1;
                currentXPath.append(WINDUP_MATCHES_FUNCTION_PREFIX).append(frameIdx).append(", ");
                continue;
            }
            currentXPath.append(curChar);
        }
        Pattern leadingAndTrailingWhitespace = Pattern.compile("(\\s*)(.*?)(\\s*)");
        StringBuilder finalResult = new StringBuilder();
        for (StringBuilder compiledXPath : compiledXPaths) {
            Matcher whitespaceMatcher;
            if (!StringUtils.isNotBlank((CharSequence)compiledXPath) || !(whitespaceMatcher = leadingAndTrailingWhitespace.matcher(compiledXPath)).matches()) continue;
            compiledXPath = new StringBuilder();
            compiledXPath.append(whitespaceMatcher.group(1));
            compiledXPath.append(whitespaceMatcher.group(2));
            compiledXPath.append("/self::node()[windup:persist(").append(frameIdx).append(", ").append(".)]");
            compiledXPath.append(whitespaceMatcher.group(3));
            if (StringUtils.isNotBlank((CharSequence)finalResult)) {
                finalResult.append("|");
            }
            finalResult.append((CharSequence)compiledXPath);
        }
        return finalResult.toString();
    }
}

