/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.windup.ast.java.ASTException;
import org.jboss.windup.ast.java.ReferenceResolvingVisitorState;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.ClassReference;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.ast.java.data.annotations.AnnotationArrayValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationClassReference;
import org.jboss.windup.ast.java.data.annotations.AnnotationLiteralValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationValue;

public class ReferenceResolvingVisitor
extends ASTVisitor {
    private static final Logger LOG = Logger.getLogger(ReferenceResolvingVisitor.class.getName());
    private final WildcardImportResolver wildcardImportResolver;
    private final String path;
    private final CompilationUnit compilationUnit;
    private final List<ClassReference> classReferences = new ArrayList<ClassReference>();
    private final ReferenceResolvingVisitorState state = new ReferenceResolvingVisitorState();
    private String packageName;
    private String className;

    public ReferenceResolvingVisitor(WildcardImportResolver importResolver, CompilationUnit compilationUnit, String path) {
        this.wildcardImportResolver = importResolver;
        this.compilationUnit = compilationUnit;
        this.path = path;
        this.resolveCurrentTypeNames(compilationUnit);
    }

    private void resolveCurrentTypeNames(CompilationUnit compilationUnit) {
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        this.packageName = packageDeclaration == null ? "" : packageDeclaration.getName().getFullyQualifiedName();
        List types = compilationUnit.types();
        List importDeclarations = compilationUnit.imports();
        for (ImportDeclaration importDeclaration : importDeclarations) {
            this.processImport(importDeclaration);
        }
        String fqcn = null;
        if (!types.isEmpty()) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)types.get(0);
            this.className = typeDeclaration.getName().getFullyQualifiedName();
            fqcn = this.packageName.isEmpty() ? this.className : this.packageName + "." + this.className;
            String typeLine = typeDeclaration.toString();
            if (typeDeclaration.getJavadoc() != null) {
                typeLine = typeLine.substring(typeDeclaration.getJavadoc().toString().length());
            }
            ClassReference mainTypeClassReference = new ClassReference(fqcn, this.packageName, this.className, null, ResolutionStatus.RESOLVED, TypeReferenceLocation.TYPE, compilationUnit.getLineNumber(typeDeclaration.getStartPosition()), compilationUnit.getColumnNumber(compilationUnit.getStartPosition()), compilationUnit.getLength(), this.extractDefinitionLine(typeLine));
            this.classReferences.add(mainTypeClassReference);
            this.processModifiers(mainTypeClassReference, typeDeclaration.modifiers());
            if (typeDeclaration instanceof TypeDeclaration) {
                Type superclassType = ((TypeDeclaration)typeDeclaration).getSuperclassType();
                ITypeBinding resolveBinding = null;
                if (superclassType != null) {
                    resolveBinding = superclassType.resolveBinding();
                }
                if (resolveBinding == null && superclassType != null) {
                    ResolveClassnameResult resolvedResult = this.resolveClassname(superclassType.toString());
                    PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(resolvedResult.result);
                    String superPackageName = packageAndClassName.packageName;
                    String superClassName = packageAndClassName.className;
                    ResolutionStatus superResolutionStatus = resolvedResult.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                    this.classReferences.add(new ClassReference(resolvedResult.result, superClassName, superPackageName, null, superResolutionStatus, TypeReferenceLocation.TYPE, compilationUnit.getLineNumber(typeDeclaration.getStartPosition()), compilationUnit.getColumnNumber(compilationUnit.getStartPosition()), compilationUnit.getLength(), this.extractDefinitionLine(typeDeclaration.toString())));
                }
                while (resolveBinding != null) {
                    if (superclassType.resolveBinding() != null) {
                        String superPackageName = resolveBinding.getPackage().getName();
                        String superClassName = resolveBinding.getName();
                        this.classReferences.add(new ClassReference(resolveBinding.getQualifiedName(), superClassName, superPackageName, null, ResolutionStatus.RESOLVED, TypeReferenceLocation.TYPE, compilationUnit.getLineNumber(typeDeclaration.getStartPosition()), compilationUnit.getColumnNumber(compilationUnit.getStartPosition()), compilationUnit.getLength(), this.extractDefinitionLine(typeDeclaration.toString())));
                    }
                    resolveBinding = resolveBinding.getSuperclass();
                }
            }
        }
        this.state.getNames().add("this");
        this.state.getNameInstance().put("this", fqcn);
    }

    private String extractDefinitionLine(String typeDeclaration) {
        String[] lines;
        String typeLine = "";
        String[] stringArray = lines = typeDeclaration.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String line;
            typeLine = line = stringArray[i];
            if (line.contains("{")) break;
        }
        return typeLine;
    }

    public List<ClassReference> getJavaClassReferences() {
        return this.classReferences;
    }

    private ClassReference processConstructor(ConstructorType interest, ResolutionStatus resolutionStatus, int lineNumber, int columnNumber, int length, String line) {
        String text = interest.toString();
        ClassReference reference = new ClassReference(text, this.packageName, this.className, "<init>", resolutionStatus, TypeReferenceLocation.CONSTRUCTOR_CALL, lineNumber, columnNumber, length, line);
        this.classReferences.add(reference);
        return reference;
    }

    private ClassReference processMethod(MethodType interest, ResolutionStatus resolutionStatus, TypeReferenceLocation location, int lineNumber, int columnNumber, int length, String line) {
        String text = interest.toString();
        ClassReference reference = new ClassReference(text, interest.packageName, interest.className, interest.methodName, resolutionStatus, location, lineNumber, columnNumber, length, line);
        this.classReferences.add(reference);
        return reference;
    }

    private void processImport(String interest, ResolutionStatus resolutionStatus, int lineNumber, int columnNumber, int length, String line) {
        PackageAndClassName packageAndClass = !interest.contains(".") ? new PackageAndClassName(interest, null) : PackageAndClassName.parseFromQualifiedName(interest);
        this.classReferences.add(new ClassReference(interest, packageAndClass.packageName, packageAndClass.className, null, resolutionStatus, TypeReferenceLocation.IMPORT, lineNumber, columnNumber, length, line));
    }

    private ClassReference processTypeBinding(ITypeBinding type, ResolutionStatus resolutionStatus, TypeReferenceLocation referenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (type == null) {
            return null;
        }
        String sourceString = this.getQualifiedName(type);
        String packageName = type.getPackage() != null ? type.getPackage().getName() : PackageAndClassName.parseFromQualifiedName(sourceString).packageName;
        String className = type.getName();
        return this.processTypeAsString(sourceString, packageName, className, resolutionStatus, referenceLocation, lineNumber, columnNumber, length, line);
    }

    private ClassReference processTypeAsEnum(ITypeBinding typeBinding, Expression expression, ResolutionStatus resolutionStatus, int lineNumber, int columnNumber, int length, String line) {
        if (expression == null) {
            return null;
        }
        String fullExpression = null;
        String enumPackage = null;
        String enumClassName = null;
        if (typeBinding != null) {
            fullExpression = typeBinding.getQualifiedName();
            enumPackage = typeBinding.getPackage().getName();
            enumClassName = typeBinding.getName();
        }
        if (expression instanceof Name) {
            if (StringUtils.isNotBlank((CharSequence)fullExpression)) {
                fullExpression = fullExpression + ".";
            }
            fullExpression = expression instanceof QualifiedName ? fullExpression + ((QualifiedName)expression).getName() : fullExpression + ((Name)expression).getFullyQualifiedName();
        }
        ClassReference reference = new ClassReference(fullExpression, enumPackage, enumClassName, null, resolutionStatus, TypeReferenceLocation.ENUM_CONSTANT, lineNumber, columnNumber, length, line);
        this.classReferences.add(reference);
        return reference;
    }

    private ClassReference processType(Type type, TypeReferenceLocation typeReferenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (type == null) {
            return null;
        }
        ITypeBinding resolveBinding = type.resolveBinding();
        if (resolveBinding == null) {
            ResolveClassnameResult resolvedResult = this.resolveClassname(type.toString());
            ResolutionStatus status = resolvedResult.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
            PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(resolvedResult.result);
            return this.processTypeAsString(resolvedResult.result, packageAndClassName.packageName, packageAndClassName.className, status, typeReferenceLocation, lineNumber, columnNumber, length, line);
        }
        return this.processTypeBinding(type.resolveBinding(), ResolutionStatus.RESOLVED, typeReferenceLocation, lineNumber, columnNumber, length, line);
    }

    private ClassReference processTypeAsString(String sourceString, String packageName, String className, ResolutionStatus resolutionStatus, TypeReferenceLocation referenceLocation, int lineNumber, int columnNumber, int length, String line) {
        if (sourceString == null) {
            return null;
        }
        line = line.replaceAll("(\\n)|(\\r)", "");
        ClassReference typeRef = new ClassReference(sourceString, packageName, className, null, resolutionStatus, referenceLocation, lineNumber, columnNumber, length, line);
        this.classReferences.add(typeRef);
        return typeRef;
    }

    public boolean visit(MethodDeclaration node) {
        List throwsTypes;
        ResolutionStatus resolutionStatus;
        IMethodBinding resolveBinding = node.resolveBinding();
        ITypeBinding returnType = null;
        if (resolveBinding != null) {
            resolutionStatus = ResolutionStatus.RESOLVED;
            returnType = node.resolveBinding().getReturnType();
        } else {
            resolutionStatus = ResolutionStatus.RECOVERED;
        }
        if (returnType != null) {
            this.processTypeBinding(returnType, ResolutionStatus.RESOLVED, TypeReferenceLocation.RETURN_TYPE, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
        } else {
            Type methodReturnType = node.getReturnType2();
            this.processType(methodReturnType, TypeReferenceLocation.RETURN_TYPE, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
        }
        ArrayList<String> qualifiedArguments = new ArrayList<String>();
        List parameters = node.parameters();
        if (parameters != null) {
            for (SingleVariableDeclaration type : parameters) {
                this.state.getNames().add(type.getName().toString());
                String typeName = type.getType().toString();
                typeName = this.resolveClassname(typeName).result;
                qualifiedArguments.add(typeName);
                this.state.getNameInstance().put(type.getName().toString(), typeName);
                ClassReference parameterClassReference = this.processType(type.getType(), TypeReferenceLocation.METHOD_PARAMETER, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                this.processModifiers(parameterClassReference, type.modifiers());
            }
        }
        if ((throwsTypes = node.thrownExceptionTypes()) != null) {
            for (Type type : throwsTypes) {
                this.processType(type, TypeReferenceLocation.THROWS_METHOD_DECLARATION, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(type.getStartPosition()), type.getLength(), this.extractDefinitionLine(node.toString()));
            }
        }
        MethodType methodCall = new MethodType(this.state.getNameInstance().get("this"), this.packageName, this.className, node.getName().toString(), qualifiedArguments);
        ClassReference methodReference = this.processMethod(methodCall, resolutionStatus, TypeReferenceLocation.METHOD, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), this.compilationUnit.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), this.extractDefinitionLine(node.toString()));
        this.processModifiers(methodReference, node.modifiers());
        return super.visit(node);
    }

    public boolean visit(InstanceofExpression node) {
        Type type = node.getRightOperand();
        this.processType(type, TypeReferenceLocation.INSTANCE_OF, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(type.getStartPosition()), type.getLength(), node.toString());
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            Type type = cic.getType();
            this.processType(type, TypeReferenceLocation.THROW_STATEMENT, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(cic.getStartPosition()), cic.getLength(), node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(CatchClause node) {
        Type catchType = node.getException().getType();
        this.processType(catchType, TypeReferenceLocation.CATCH_EXCEPTION_STATEMENT, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(catchType.getStartPosition()), catchType.getLength(), node.toString());
        return super.visit(node);
    }

    public boolean visit(ReturnStatement node) {
        if (node.getExpression() instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)node.getExpression();
            ITypeBinding typeBinding = cic.getType().resolveBinding();
            if (typeBinding == null) {
                String qualifiedClass = cic.getType().toString();
                ResolveClassnameResult result = this.resolveClassname(qualifiedClass);
                qualifiedClass = result.result;
                ResolutionStatus resolutionStatus = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(qualifiedClass);
                this.processTypeAsString(qualifiedClass, packageAndClassName.packageName, packageAndClassName.className, resolutionStatus, TypeReferenceLocation.CONSTRUCTOR_CALL, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(cic.getStartPosition()), cic.getLength(), node.toString());
            } else {
                this.processTypeBinding(typeBinding, ResolutionStatus.RESOLVED, TypeReferenceLocation.CONSTRUCTOR_CALL, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(cic.getStartPosition()), cic.getLength(), node.toString());
            }
        }
        return super.visit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            ClassReference reference;
            PackageAndClassName packageAndClassName;
            ResolutionStatus status;
            ResolveClassnameResult result;
            String nodeType = node.getType().toString();
            nodeType = this.resolveClassname(nodeType).result;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            Expression expression = frag.getInitializer();
            int lineNumber = this.compilationUnit.getLineNumber(node.getStartPosition());
            int columnNumber = this.compilationUnit.getColumnNumber(node.getStartPosition());
            ITypeBinding resolveBinding = node.getType().resolveBinding();
            if (expression instanceof Name) {
                Name expressionName = (Name)expression;
                IBinding binding = expressionName.resolveBinding();
                if (binding == null) {
                    result = this.resolveClassname(expressionName.getFullyQualifiedName());
                    status = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                    packageAndClassName = PackageAndClassName.parseFromQualifiedName(result.result);
                    this.processTypeAsString(result.result, packageAndClassName.packageName, packageAndClassName.className, status, TypeReferenceLocation.VARIABLE_INITIALIZER, lineNumber, columnNumber, node.getLength(), node.toString());
                } else {
                    if (resolveBinding.isEnum()) {
                        this.processTypeAsEnum(resolveBinding, (Expression)expressionName, ResolutionStatus.RESOLVED, lineNumber, columnNumber, node.getLength(), this.extractDefinitionLine(node.toString()));
                    }
                    this.processTypeBinding(resolveBinding, ResolutionStatus.RESOLVED, TypeReferenceLocation.VARIABLE_INITIALIZER, lineNumber, columnNumber, node.getLength(), node.toString());
                }
            }
            this.state.getNames().add(frag.getName().getIdentifier());
            this.state.getNameInstance().put(frag.getName().toString(), nodeType.toString());
            ITypeBinding resolvedTypeBinding = resolveBinding;
            if (resolvedTypeBinding != null) {
                reference = this.processTypeBinding(resolvedTypeBinding, ResolutionStatus.RESOLVED, TypeReferenceLocation.FIELD_DECLARATION, lineNumber, columnNumber, node.getLength(), node.toString());
            } else {
                result = this.resolveClassname(node.getType().toString());
                status = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                packageAndClassName = PackageAndClassName.parseFromQualifiedName(result.result);
                reference = this.processTypeAsString(result.result, packageAndClassName.packageName, packageAndClassName.className, status, TypeReferenceLocation.FIELD_DECLARATION, lineNumber, columnNumber, node.getLength(), node.toString());
            }
            this.processModifiers(reference, node.modifiers());
        }
        return true;
    }

    private AnnotationValue getAnnotationValueForExpression(ClassReference annotatedReference, Expression expression) {
        AnnotationValue value;
        if (expression instanceof BooleanLiteral) {
            value = new AnnotationLiteralValue(Boolean.TYPE, ((BooleanLiteral)expression).booleanValue());
        } else if (expression instanceof CharacterLiteral) {
            value = new AnnotationLiteralValue(Character.TYPE, Character.valueOf(((CharacterLiteral)expression).charValue()));
        } else if (expression instanceof NumberLiteral) {
            ITypeBinding binding = expression.resolveTypeBinding();
            value = binding == null ? new AnnotationLiteralValue(String.class, expression.toString()) : new AnnotationLiteralValue(this.resolveLiteralType(binding), ((NumberLiteral)expression).resolveConstantExpressionValue());
        } else if (expression instanceof TypeLiteral) {
            value = new AnnotationLiteralValue(Class.class, ((TypeLiteral)expression).resolveConstantExpressionValue());
        } else if (expression instanceof StringLiteral) {
            value = new AnnotationLiteralValue(String.class, ((StringLiteral)expression).getLiteralValue());
        } else if (expression instanceof NormalAnnotation) {
            value = this.processAnnotation(annotatedReference, (Annotation)((NormalAnnotation)expression));
        } else if (expression instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
            ArrayList<AnnotationValue> arrayValues = new ArrayList<AnnotationValue>(arrayInitializer.expressions().size());
            for (Object arrayExpression : arrayInitializer.expressions()) {
                arrayValues.add(this.getAnnotationValueForExpression(annotatedReference, (Expression)arrayExpression));
            }
            value = new AnnotationArrayValue(arrayValues);
        } else if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            Object expressionValue = qualifiedName.resolveConstantExpressionValue();
            if (expressionValue == null) {
                value = new AnnotationLiteralValue(String.class, qualifiedName.toString());
            } else {
                Class<?> expressionType = expressionValue.getClass();
                value = new AnnotationLiteralValue(expressionType, expressionValue);
            }
        } else if (expression instanceof CastExpression) {
            CastExpression cast = (CastExpression)expression;
            AnnotationValue castExpressionValue = this.getAnnotationValueForExpression(annotatedReference, cast.getExpression());
            if (castExpressionValue instanceof AnnotationLiteralValue) {
                AnnotationLiteralValue literalValue = (AnnotationLiteralValue)castExpressionValue;
                ITypeBinding binding = cast.getType().resolveBinding();
                if (binding == null) {
                    value = new AnnotationLiteralValue(String.class, literalValue.getLiteralValue());
                } else {
                    Class<?> type = this.resolveLiteralType(cast.getType().resolveBinding());
                    value = new AnnotationLiteralValue(type, literalValue.getLiteralValue());
                }
            } else {
                value = castExpressionValue;
            }
        } else if (expression instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)expression;
            ITypeBinding binding = simpleName.resolveTypeBinding();
            if (binding == null) {
                value = new AnnotationLiteralValue(String.class, simpleName.toString());
            } else {
                Object expressionValue = simpleName.resolveConstantExpressionValue();
                Class<?> expressionType = expressionValue == null ? null : expressionValue.getClass();
                value = new AnnotationLiteralValue(expressionType, expressionValue);
            }
        } else {
            LOG.warning("Unexpected type: " + expression.getClass().getCanonicalName() + " in type: " + this.path + " just attempting to use it as a string value");
            value = new AnnotationLiteralValue(String.class, expression == null ? null : expression.toString());
        }
        return value;
    }

    private void addAnnotationValues(ClassReference annotatedReference, AnnotationClassReference typeRef, Annotation node) {
        HashMap<String, AnnotationValue> annotationValueMap = new HashMap<String, AnnotationValue>();
        if (node instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)node;
            AnnotationValue value = this.getAnnotationValueForExpression(annotatedReference, singleMemberAnnotation.getValue());
            annotationValueMap.put("value", value);
        } else if (node instanceof NormalAnnotation) {
            List annotationValues = ((NormalAnnotation)node).values();
            for (MemberValuePair annotationValue : annotationValues) {
                String key = annotationValue.getName().toString();
                Expression expression = annotationValue.getValue();
                AnnotationValue value = this.getAnnotationValueForExpression(annotatedReference, expression);
                annotationValueMap.put(key, value);
            }
        }
        typeRef.setAnnotationValues(annotationValueMap);
    }

    private Class<?> resolveLiteralType(ITypeBinding binding) {
        switch (binding.getName()) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        throw new ASTException("Unrecognized literal type: " + binding.getName());
    }

    private AnnotationClassReference processAnnotation(ClassReference annotatedReference, Annotation node) {
        String className;
        String packageName;
        String qualifiedName;
        ResolutionStatus status;
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding != null) {
            status = ResolutionStatus.RESOLVED;
            qualifiedName = typeBinding.getQualifiedName();
            packageName = typeBinding.getPackage().getName();
            className = typeBinding.getName();
        } else {
            ResolveClassnameResult result = this.resolveClassname(node.getTypeName().toString());
            status = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
            qualifiedName = result.result;
            PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(result.result);
            packageName = packageAndClassName.packageName;
            className = packageAndClassName.className;
        }
        AnnotationClassReference reference = new AnnotationClassReference(annotatedReference, qualifiedName, packageName, className, status, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), node.toString());
        this.addAnnotationValues(annotatedReference, reference, node);
        return reference;
    }

    private void processModifiers(ClassReference originalReference, List modifiers) {
        for (Object modifier : modifiers) {
            AnnotationClassReference reference;
            if (modifier instanceof NormalAnnotation) {
                reference = this.processAnnotation(originalReference, (Annotation)((NormalAnnotation)modifier));
                this.classReferences.add(reference);
                continue;
            }
            if (modifier instanceof SingleMemberAnnotation) {
                reference = this.processAnnotation(originalReference, (Annotation)((SingleMemberAnnotation)modifier));
                this.classReferences.add(reference);
                continue;
            }
            if (modifier instanceof MarkerAnnotation) {
                reference = this.processAnnotation(originalReference, (Annotation)((MarkerAnnotation)modifier));
                this.classReferences.add(reference);
                continue;
            }
            if (modifier instanceof Modifier) {
                if (!((Modifier)modifier).isAnnotation()) continue;
                throw new RuntimeException("Failed due to unexpected Modifier that is also an annotation: " + modifier.getClass().getCanonicalName());
            }
            throw new RuntimeException("Failed due to unexpected type: " + modifier.getClass().getCanonicalName());
        }
    }

    public boolean visit(TypeDeclaration node) {
        Object clzInterfaces = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
        Object clzSuperClasses = node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (clzInterfaces != null && List.class.isAssignableFrom(clzInterfaces.getClass())) {
            TypeReferenceLocation typeReferenceLocation = node.isInterface() ? TypeReferenceLocation.INHERITANCE : TypeReferenceLocation.IMPLEMENTS_TYPE;
            List clzInterfacesList = (List)clzInterfaces;
            for (Object clzInterface : clzInterfacesList) {
                ParameterizedType parameterizedType = null;
                if (clzInterface instanceof ParameterizedType) {
                    parameterizedType = (ParameterizedType)clzInterface;
                    clzInterface = parameterizedType.getType();
                }
                if (!(clzInterface instanceof SimpleType)) continue;
                SimpleType simpleType = (SimpleType)clzInterface;
                ITypeBinding resolvedSuperInterface = simpleType.resolveBinding();
                if (resolvedSuperInterface == null) {
                    ResolveClassnameResult result = this.resolveClassname(simpleType.getName().toString());
                    ResolutionStatus status = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                    PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(result.result);
                    this.processTypeAsString(result.result, packageAndClassName.packageName, packageAndClassName.className, status, typeReferenceLocation, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                    continue;
                }
                Stack<ITypeBinding> stack = new Stack<ITypeBinding>();
                stack.push(resolvedSuperInterface);
                while (!stack.isEmpty()) {
                    ITypeBinding[] interfaces;
                    resolvedSuperInterface = (ITypeBinding)stack.pop();
                    this.processTypeBinding(resolvedSuperInterface, ResolutionStatus.RESOLVED, typeReferenceLocation, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                    if (resolvedSuperInterface == null) continue;
                    for (ITypeBinding oneInterface : interfaces = resolvedSuperInterface.getInterfaces()) {
                        stack.push(oneInterface);
                    }
                }
            }
        }
        if (clzSuperClasses != null && clzSuperClasses instanceof SimpleType) {
            ITypeBinding resolvedSuperClass = ((SimpleType)clzSuperClasses).resolveBinding();
            if (resolvedSuperClass == null) {
                ResolveClassnameResult result = this.resolveClassname(((SimpleType)clzSuperClasses).getName().toString());
                ResolutionStatus status = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
                PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(result.result);
                this.processTypeAsString(result.result, packageAndClassName.packageName, packageAndClassName.className, status, TypeReferenceLocation.INHERITANCE, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
            }
            while (resolvedSuperClass != null && !resolvedSuperClass.getQualifiedName().equals("java.lang.Object")) {
                this.processTypeBinding(resolvedSuperClass, ResolutionStatus.RESOLVED, TypeReferenceLocation.INHERITANCE, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                for (ITypeBinding iface : resolvedSuperClass.getInterfaces()) {
                    this.processTypeBinding(iface, ResolutionStatus.RESOLVED, TypeReferenceLocation.IMPLEMENTS_TYPE, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), this.extractDefinitionLine(node.toString()));
                }
                resolvedSuperClass = resolvedSuperClass.getSuperclass();
            }
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (int i = 0; i < node.fragments().size(); ++i) {
            String nodeType = node.getType().toString();
            VariableDeclarationFragment frag = (VariableDeclarationFragment)node.fragments().get(i);
            this.state.getNames().add(frag.getName().getIdentifier());
            this.state.getNameInstance().put(frag.getName().toString(), nodeType.toString());
        }
        this.processType(node.getType(), TypeReferenceLocation.VARIABLE_DECLARATION, this.compilationUnit.getLineNumber(node.getStartPosition()), this.compilationUnit.getColumnNumber(node.getStartPosition()), node.getLength(), node.toString());
        return super.visit(node);
    }

    private void processImport(ImportDeclaration node) {
        String name = node.getName().toString();
        if (node.isOnDemand()) {
            String[] resolvedNames;
            this.state.getWildcardImports().add(name);
            for (String resolvedName : resolvedNames = this.wildcardImportResolver.resolve(name)) {
                this.processImport(resolvedName, ResolutionStatus.RESOLVED, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), this.compilationUnit.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString().trim());
            }
            this.processImport(name + ".*", ResolutionStatus.RESOLVED, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), this.compilationUnit.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString().trim());
        } else {
            String clzName = StringUtils.substringAfterLast((String)name, (String)".");
            this.state.getClassNameLookedUp().add(clzName);
            this.state.getClassNameToFQCN().put(clzName, name);
            ResolutionStatus status = node.resolveBinding() != null ? ResolutionStatus.RESOLVED : ResolutionStatus.RECOVERED;
            this.processImport(name, status, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), this.compilationUnit.getColumnNumber(node.getName().getStartPosition()), node.getName().getLength(), node.toString().trim());
        }
    }

    public boolean visit(MethodInvocation node) {
        ResolutionStatus resolutionStatus;
        if (!StringUtils.contains((CharSequence)node.toString(), (CharSequence)".")) {
            return true;
        }
        ArrayList<String> qualifiedInstances = new ArrayList<String>();
        ArrayList<String> argumentsQualified = new ArrayList<String>();
        IMethodBinding resolveTypeBinding = node.resolveMethodBinding();
        int columnNumber = this.compilationUnit.getColumnNumber(node.getName().getStartPosition());
        int length = node.getName().getLength();
        if (resolveTypeBinding != null) {
            resolutionStatus = ResolutionStatus.RESOLVED;
            ITypeBinding[] argumentTypeBindings = resolveTypeBinding.getParameterTypes();
            List arguments = node.arguments();
            int index = 0;
            for (ITypeBinding type : argumentTypeBindings) {
                argumentsQualified.add(type.getQualifiedName());
                if (!type.isEnum()) continue;
                if (arguments.size() > index) {
                    Expression expression = (Expression)arguments.get(index);
                    this.processTypeAsEnum(type, expression, resolutionStatus, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), columnNumber, length, this.extractDefinitionLine(node.toString()));
                }
                ++index;
            }
            if (resolveTypeBinding != null && resolveTypeBinding.getDeclaringClass() != null) {
                ITypeBinding[] interfaces;
                ITypeBinding declaringClass = resolveTypeBinding.getDeclaringClass();
                qualifiedInstances.add(declaringClass.getQualifiedName());
                for (ITypeBinding possibleInterface : interfaces = declaringClass.getInterfaces()) {
                    IMethodBinding[] declaredMethods = possibleInterface.getDeclaredMethods();
                    if (declaredMethods.length == 0) continue;
                    for (IMethodBinding interfaceMethod : declaredMethods) {
                        if (!interfaceMethod.getName().equals(node.getName().toString())) continue;
                        ArrayList<String> interfaceMethodArguments = new ArrayList<String>();
                        for (ITypeBinding type : interfaceMethod.getParameterTypes()) {
                            interfaceMethodArguments.add(type.getQualifiedName());
                        }
                        if (!interfaceMethodArguments.equals(argumentsQualified)) continue;
                        qualifiedInstances.add(possibleInterface.getQualifiedName());
                    }
                }
            }
        } else {
            resolutionStatus = ResolutionStatus.RECOVERED;
            String nodeName = StringUtils.removeStart((String)node.toString(), (String)"this.");
            String objRef = StringUtils.substringBefore((String)nodeName, (String)("." + node.getName().toString()));
            if (this.state.getNameInstance().containsKey(objRef)) {
                objRef = this.state.getNameInstance().get(objRef);
            }
            objRef = this.resolveClassname(objRef).result;
            List arguments = node.arguments();
            for (Expression expression : arguments) {
                ITypeBinding argumentBinding = expression.resolveTypeBinding();
                if (argumentBinding != null) {
                    String constantEnum;
                    argumentsQualified.add(argumentBinding.getQualifiedName());
                    if (!argumentBinding.isEnum() || (constantEnum = expression.toString()) == null) continue;
                    this.processTypeAsEnum(argumentBinding, expression, ResolutionStatus.RESOLVED, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), columnNumber, length, this.extractDefinitionLine(node.toString()));
                    continue;
                }
                PackageAndClassName argumentQualifiedGuess = PackageAndClassName.parseFromQualifiedName(expression.toString());
                argumentsQualified.add(argumentQualifiedGuess.toString());
            }
            qualifiedInstances.add(objRef);
        }
        for (String qualifiedInstance : qualifiedInstances) {
            PackageAndClassName packageAndClassName = PackageAndClassName.parseFromQualifiedName(qualifiedInstance);
            MethodType methodCall = new MethodType(qualifiedInstance, packageAndClassName.packageName, packageAndClassName.className, node.getName().toString(), argumentsQualified);
            this.processMethod(methodCall, resolutionStatus, TypeReferenceLocation.METHOD_CALL, this.compilationUnit.getLineNumber(node.getName().getStartPosition()), columnNumber, length, node.toString());
        }
        return super.visit(node);
    }

    public boolean visit(PackageDeclaration node) {
        return super.visit(node);
    }

    private String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        String qualifiedName = typeBinding.getQualifiedName();
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            if (typeBinding.isAnonymous()) {
                if (typeBinding.getSuperclass() != null) {
                    qualifiedName = this.getQualifiedName(typeBinding.getSuperclass());
                } else if (typeBinding instanceof AnonymousClassDeclaration) {
                    qualifiedName = ((AnonymousClassDeclaration)typeBinding).toString();
                }
            } else if (StringUtils.isEmpty((CharSequence)qualifiedName) && typeBinding.isNested()) {
                qualifiedName = typeBinding.getName();
            }
        }
        return qualifiedName;
    }

    public boolean visit(ClassInstanceCreation node) {
        ResolutionStatus resolutionStatus;
        int lineNumber = this.compilationUnit.getLineNumber(node.getType().getStartPosition());
        int columnNumber = this.compilationUnit.getColumnNumber(node.getType().getStartPosition());
        int length = node.getType().getLength();
        IMethodBinding constructorBinding = node.resolveConstructorBinding();
        String qualifiedClass = "";
        ArrayList<String> constructorMethodQualifiedArguments = new ArrayList<String>();
        if (constructorBinding != null && constructorBinding.getDeclaringClass() != null) {
            ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
            qualifiedClass = this.getQualifiedName(declaringClass);
            List arguments = node.arguments();
            int index = 0;
            for (ITypeBinding type : constructorBinding.getParameterTypes()) {
                if (type.isEnum() && arguments.size() > index) {
                    Expression argument = (Expression)arguments.get(index);
                    this.processTypeAsEnum(type, argument, ResolutionStatus.RESOLVED, lineNumber, columnNumber, length, this.extractDefinitionLine(node.toString()));
                }
                ++index;
                String qualifiedArgumentClass = type.getQualifiedName();
                if (qualifiedArgumentClass == null) continue;
                constructorMethodQualifiedArguments.add(qualifiedArgumentClass);
            }
        }
        if (constructorMethodQualifiedArguments.isEmpty() && !node.arguments().isEmpty()) {
            List arguments = node.arguments();
            ((Expression)arguments.get(0)).resolveTypeBinding();
            for (Expression type : arguments) {
                ITypeBinding argumentBinding = type.resolveTypeBinding();
                if (argumentBinding != null) {
                    constructorMethodQualifiedArguments.add(argumentBinding.getQualifiedName());
                    continue;
                }
                List<String> guessedParam = this.methodParameterGuesser(Collections.singletonList(type));
                constructorMethodQualifiedArguments.addAll(guessedParam);
            }
        }
        if (qualifiedClass == null || qualifiedClass.isEmpty()) {
            qualifiedClass = node.getType().toString();
            ResolveClassnameResult result = this.resolveClassname(qualifiedClass);
            qualifiedClass = result.result;
            resolutionStatus = result.found ? ResolutionStatus.RECOVERED : ResolutionStatus.UNRESOLVED;
        } else {
            resolutionStatus = ResolutionStatus.RESOLVED;
        }
        ConstructorType resolvedConstructor = new ConstructorType(qualifiedClass, constructorMethodQualifiedArguments);
        this.processConstructor(resolvedConstructor, resolutionStatus, lineNumber, columnNumber, length, node.toString());
        return super.visit(node);
    }

    private List<String> methodParameterGuesser(List<?> arguments) {
        ArrayList<String> resolvedParams = new ArrayList<String>(arguments.size());
        for (Object o : arguments) {
            if (o instanceof SimpleName) {
                String name = this.state.getNameInstance().get(o.toString());
                if (name != null) {
                    resolvedParams.add(name);
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof StringLiteral) {
                resolvedParams.add("java.lang.String");
                continue;
            }
            if (o instanceof FieldAccess) {
                String field = ((FieldAccess)o).getName().toString();
                if (this.state.getNames().contains(field)) {
                    resolvedParams.add(this.state.getNameInstance().get(field));
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof CastExpression) {
                String type = ((CastExpression)o).getType().toString();
                type = this.qualifyType(type);
                resolvedParams.add(type);
                continue;
            }
            if (o instanceof MethodInvocation) {
                String on = ((MethodInvocation)o).getName().toString();
                if (StringUtils.equals((CharSequence)on, (CharSequence)"toString")) {
                    if (((MethodInvocation)o).arguments().size() != 0) continue;
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof NumberLiteral) {
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"L")) {
                    resolvedParams.add("long");
                    continue;
                }
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"f")) {
                    resolvedParams.add("float");
                    continue;
                }
                if (StringUtils.endsWith((CharSequence)o.toString(), (CharSequence)"d")) {
                    resolvedParams.add("double");
                    continue;
                }
                resolvedParams.add("int");
                continue;
            }
            if (o instanceof BooleanLiteral) {
                resolvedParams.add("boolean");
                continue;
            }
            if (o instanceof ClassInstanceCreation) {
                String nodeType = ((ClassInstanceCreation)o).getType().toString();
                nodeType = this.resolveClassname(nodeType).result;
                resolvedParams.add(nodeType);
                continue;
            }
            if (o instanceof CharacterLiteral) {
                resolvedParams.add("char");
                continue;
            }
            if (o instanceof InfixExpression) {
                String expression = o.toString();
                if (StringUtils.contains((CharSequence)expression, (CharSequence)"\"")) {
                    resolvedParams.add("java.lang.String");
                    continue;
                }
                resolvedParams.add("Undefined");
                continue;
            }
            if (o instanceof QualifiedName) {
                String paramGuessed = ((QualifiedName)o).getFullyQualifiedName();
                PackageAndClassName qualifiedParam = PackageAndClassName.parseFromQualifiedName(paramGuessed);
                resolvedParams.add(qualifiedParam.toString());
                continue;
            }
            resolvedParams.add("Undefined");
        }
        return resolvedParams;
    }

    private ResolveClassnameResult resolveClassname(String sourceClassname) {
        if (!StringUtils.contains((CharSequence)sourceClassname, (CharSequence)".")) {
            if (this.state.getClassNameLookedUp().contains(sourceClassname)) {
                String qualifiedName = this.state.getClassNameToFQCN().get(sourceClassname);
                if (qualifiedName != null) {
                    return new ResolveClassnameResult(true, qualifiedName);
                }
                return new ResolveClassnameResult(false, sourceClassname);
            }
            this.state.getClassNameLookedUp().add(sourceClassname);
            String resolvedClassName = this.wildcardImportResolver.resolve(this.state.getWildcardImports(), sourceClassname);
            if (resolvedClassName != null) {
                this.state.getClassNameToFQCN().put(sourceClassname, resolvedClassName);
                return new ResolveClassnameResult(true, resolvedClassName);
            }
            return new ResolveClassnameResult(false, sourceClassname);
        }
        return new ResolveClassnameResult(true, sourceClassname);
    }

    private String qualifyType(String objRef) {
        objRef = StringUtils.removeEnd((String)objRef, (String)"[]");
        if (this.state.getNameInstance().containsKey(objRef)) {
            objRef = this.state.getNameInstance().get(objRef);
        }
        objRef = this.resolveClassname(objRef).result;
        return objRef;
    }

    private class ResolveClassnameResult {
        private boolean found;
        private String result;

        public ResolveClassnameResult(boolean found, String result) {
            this.found = found;
            this.result = result;
        }
    }

    private static class PackageAndClassName {
        private String packageName;
        private String className;

        public PackageAndClassName(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.packageName != null) {
                sb.append(this.packageName).append(".");
            }
            if (this.className != null) {
                sb.append(this.className);
            }
            return sb.toString();
        }

        public static PackageAndClassName parseFromQualifiedName(String qualifiedName) {
            String className;
            String packageName;
            if (qualifiedName.contains(".*")) {
                packageName = qualifiedName.replace("*", "");
                className = null;
            } else {
                int lastDot = qualifiedName.lastIndexOf(46);
                if (lastDot == -1) {
                    packageName = null;
                    className = qualifiedName;
                } else {
                    packageName = qualifiedName.substring(0, lastDot);
                    className = qualifiedName.substring(lastDot + 1);
                }
            }
            return new PackageAndClassName(packageName, className);
        }
    }

    private static class ConstructorType {
        private final String qualifiedName;
        private final List<String> qualifiedParameters;

        public ConstructorType(String qualifiedName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    private static class MethodType {
        private final String qualifiedName;
        private final String packageName;
        private final String className;
        private final String methodName;
        private final List<String> qualifiedParameters;

        MethodType(String qualifiedName, String packageName, String className, String methodName, List<String> qualifiedParameters) {
            this.qualifiedName = qualifiedName;
            this.packageName = packageName;
            this.className = className;
            this.methodName = methodName;
            this.qualifiedParameters = qualifiedParameters != null ? qualifiedParameters : new LinkedList<String>();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.qualifiedName).append(".").append(this.methodName);
            builder.append("(");
            int j = this.qualifiedParameters.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String param = this.qualifiedParameters.get(i);
                builder.append(param);
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

