/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.config;

import java.util.Arrays;
import java.util.List;
import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class ScanPackagesOption
extends AbstractConfigurationOption {
    public static final String NAME = "packages";

    public String getDescription() {
        return "A list of java package name prefixes to scan (eg, com.myapp). Multiple items can be separated by a space (eg, --packages PACKAGE_1 PACKAGE_2).";
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Java packages to scan";
    }

    public Class<?> getType() {
        return String.class;
    }

    public InputType getUIType() {
        return InputType.MANY;
    }

    public boolean isRequired() {
        return false;
    }

    public ValidationResult validate(Object value) {
        if (this.packagesNotSpecified((List)value)) {
            String message = "No packages were set in --packages. This will cause all .jar files to be decompiled and can possibly take a long time. Check the Windup User Guide for performance tips.";
            return new ValidationResult(ValidationResult.Level.WARNING, message);
        }
        if (this.packagesTooGeneral((List)value)) {
            String message = "The packages specified to scan are very broad. This may cause many .jar files to be decompiled and can possibly take a long time. Check the Windup User Guide for performance tips.";
            return new ValidationResult(ValidationResult.Level.WARNING, message);
        }
        return ValidationResult.SUCCESS;
    }

    private boolean packagesTooGeneral(List<String> includeJavaPackages) {
        List<String> generalPackages = Arrays.asList("com", "org", "net");
        for (String packge : includeJavaPackages) {
            if (generalPackages.contains(packge)) continue;
            return false;
        }
        return true;
    }

    private boolean packagesNotSpecified(List<String> includeJavaPackages) {
        return includeJavaPackages == null || includeJavaPackages.isEmpty();
    }
}

