/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.orion;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover Orion EJB XML Files")
public class ResolveOrionEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveOrionEjbXmlRuleProvider.class.getSimpleName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"orion-ejb-jar");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        Object jndiRef;
        String destination;
        String ejbName;
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        technologyTagService.addTagToFileModel((FileModel)payload, "Orion EJB XML", TechnologyTagLevel.IMPORTANT);
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)payload.getProjectModel());
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref-mapping").get()) {
            String jndiLocation = JOOX.$((Element)resourceRef).attr("location");
            String resourceName = JOOX.$((Element)resourceRef).attr("name");
            if (!StringUtils.isNotBlank((CharSequence)jndiLocation) || !StringUtils.isNotBlank((CharSequence)resourceName)) continue;
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element ejbRef : JOOX.$((Document)doc).find("session-deployment").get()) {
            ejbName = JOOX.$((Element)ejbRef).attr("name");
            if (!StringUtils.isNotBlank((CharSequence)ejbName)) continue;
            LOG.info("Looking up name: " + ejbName);
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                destination = JOOX.$((Element)ejbRef).attr("location");
                if (!StringUtils.isNotBlank((CharSequence)destination)) continue;
                jndiRef = jndiResourceService.createUnique(applications, destination);
                ejb.setGlobalJndiReference((JNDIResourceModel)jndiRef);
            }
        }
        for (Element messageDrivenRef : JOOX.$((Document)doc).find("message-driven-deployment").get()) {
            ejbName = JOOX.$((Element)messageDrivenRef).attr("name");
            if (!StringUtils.isNotBlank((CharSequence)ejbName)) continue;
            LOG.info("Looking up name: " + ejbName);
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                destination = JOOX.$((Element)messageDrivenRef).attr("destination-location");
                for (Element configProperty : JOOX.$((Element)messageDrivenRef).find("config-property").get()) {
                    String name = JOOX.$((Element)configProperty).child("config-property-name").text();
                    String value = JOOX.$((Element)configProperty).child("config-property-value").text();
                    if (!StringUtils.isBlank((CharSequence)destination) || !StringUtils.equals((CharSequence)"DestinationName", (CharSequence)name)) continue;
                    destination = value;
                }
                if (!StringUtils.isNotBlank((CharSequence)destination)) continue;
                jndiRef = jmsDestinationService.createUnique(applications, destination);
                mdb.setDestination((JmsDestinationModel)jndiRef);
            }
        }
    }
}

