/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.orion;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverWebXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverWebXmlRuleProvider.class}, perform="Discover Orion Web XML Files")
public class ResolveOrionWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"orion-web-app");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "web.xml");
        TechnologyTagModel technologyTag = technologyTagService.addTagToFileModel((FileModel)payload, "Orion Web XML", TechnologyTagLevel.IMPORTANT);
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)payload.getProjectModel());
        for (Element orionWeb : JOOX.$((Document)doc).child("orion-web-app")) {
            String majorVersion = JOOX.$((Element)orionWeb).attr("schema-major-version");
            String minorVersion = JOOX.$((Element)orionWeb).attr("schema-minor-version");
            if (!StringUtils.isNotBlank((CharSequence)majorVersion)) continue;
            String version = majorVersion;
            if (StringUtils.isNotBlank((CharSequence)minorVersion)) {
                version = version + "." + minorVersion;
            }
            technologyTag.setVersion(version);
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref-mapping").get()) {
            String jndiLocation = JOOX.$((Element)resourceRef).attr("location");
            String resourceName = JOOX.$((Element)resourceRef).attr("name");
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

