/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover WebSphere EJB XML Files")
public class ResolveWebSphereEjbExtensionXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-ejb-jar-ext.xmi").withProperty("rootTagName", (Object)"EJBJarExtension");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification(event, context, (FileModel)payload, "mandatory", "WebSphere EJB Ext", "WebSphere Enterprise Java Bean Extension XML Descriptor.");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "WebSphere EJB Ext", TechnologyTagLevel.IMPORTANT);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
    }
}

